package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-08-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "JobAmazonAdLog对象", description = "")
@AllArgsConstructor
@NoArgsConstructor
public class JobAmazonAdLog implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final Integer produceAds = 1;
    public static final Integer display = 4;


    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "与dc_base_company_account账号id关联")
    private Integer accountId;

    @ApiModelProperty(value = "报告id")
    private String reportId;

    @ApiModelProperty(value = "报告日期")
    private LocalDate reportDate;

    @ApiModelProperty(value = "状态,报告是否已生成")
    private Boolean status;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime bjCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime bjModified;

    @ApiModelProperty(value = "站点-英文")
    private String siteEn;

    @ApiModelProperty(value = "公司Id")
    private Integer companyId;

    private Integer type;


}
