package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcSemiPurchaseDetail对象", description="半成品采购明细表")
public class DcSemiPurchaseDetail implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "采购单ID")
    private Integer buyId;

    @ApiModelProperty(value = "采购明细ID")
    private Integer detailId;

    @ApiModelProperty(value = "采购单编号")
    private String buyNo;

    @ApiModelProperty(value = "供应商ID")
    private Integer supplierId;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "sku编码")
    private String skuCode;

    @ApiModelProperty(value = "sku名称")
    private String skuName;

    @ApiModelProperty(value = "仓库ID")
    private Integer warehouseId;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "在途数量")
    private BigDecimal transferQuantity;

    @ApiModelProperty(value = "采购单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "半成品系统最后更新时间")
    private Date semiUpdateDate;

    @ApiModelProperty(value = "sku是否从采购单移除：0-否，1-是")
    private Integer skuDelStatus;

    @ApiModelProperty(value = "采购单是否作废：0-否，1-是")
    private Integer purchaseDelStatus;
}
