package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 每日销量表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcDailySales对象", description="每日销量表")
public class DcDailySales implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "SKU名称")
    private String bailunSkuTitleCn;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "仓库")
    private String warehouseCode;

    @ApiModelProperty(value = "百伦分类Id")
    private Integer bailunCategoryId;

    @ApiModelProperty(value = "过去一日总销量")
    private Integer onedayTotalSales;

    @ApiModelProperty(value = "过去三日总销量")
    private Integer threedayTotalSales;

    @ApiModelProperty(value = "过去七日总销量")
    private Integer sevendayTotalSales;

    @ApiModelProperty(value = "过去十四日总销量")
    private Integer fourteendayTotalSales;

    @ApiModelProperty(value = "过去三十日总销量")
    private Integer thirtydayTotalSales;

    @ApiModelProperty(value = "过去三日平均销量")
    private Integer threedayAverageSales;

    @ApiModelProperty(value = "过去七日平均销量")
    private BigDecimal sevendayAverageSales;

    @ApiModelProperty(value = "过去十四日平均销量")
    private BigDecimal fourteendayAverageSales;

    @ApiModelProperty(value = "过去三十日平均销量")
    private BigDecimal thirtydayAverageSales;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "全局公司ID")
    private Integer globalCompanyId;

    @ApiModelProperty(value = "全局公司编码")
    private String globalCompanyCode;

    @ApiModelProperty(value = "全局公司名称")
    private String globalCompanyName;

    @ApiModelProperty(value = "记录时间")
    private LocalDate recordDate;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;


}
