package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * SKU调拨计划单流水表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseTransferPlan对象", description="SKU调拨计划单流水表")
public class DcBaseTransferPlan implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "调拨计划单号")
    private String transferPlanOrderId;

    @ApiModelProperty(value = "调拨目的仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "调拨目的仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "计划单状态,1为创建11为完成计划单且创建了调拨单")
    private String status;

    @ApiModelProperty(value = "调拨系统更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "调拨数量")
    private Integer count;

    @ApiModelProperty(value = "SKU标题")
    private String skuTitle;

    @ApiModelProperty(value = "调拨系统主键")
    private Integer transferKey;

    @ApiModelProperty(value = "是否被删除")
    private Boolean deleted;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "起始仓")
    private String sourceWarehouseCode;

    @ApiModelProperty(value = "交运方式")
    private String transportType;


}
