package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 实时环球库存信息表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseStock对象", description="实时环球库存信息表")
public class DcBaseStock implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "商品编号")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "货主编码")
    private String ownerCode;

    @ApiModelProperty(value = "订货数量")
    private Integer quantityReservation;

    @ApiModelProperty(value = "运输在途")
    private Integer quantityTransport;

    @ApiModelProperty(value = "中转仓库存")
    private Integer quantityTransfer;

    @ApiModelProperty(value = "冻结库存")
    private Integer quantityFreeze;

    @ApiModelProperty(value = "供应商库存")
    private Integer quantitySupplier;

    @ApiModelProperty(value = "预售库存")
    private Integer quantityPresell;

    @ApiModelProperty(value = "不良品库存")
    private Integer quantityDefective;

    @ApiModelProperty(value = "在途库存")
    private Integer quantityTransit;

    @ApiModelProperty(value = "收货待检")
    private Integer waitCheck;

    @ApiModelProperty(value = "待上架")
    private Integer waitPutaway;

    @ApiModelProperty(value = "可配库存")
    private Integer usableStock;

    @ApiModelProperty(value = "销售可用库存(聚合)")
    private Integer usableSales;

    @ApiModelProperty(value = "销售可用库存(私有)")
    private Integer usableSalesPrivate;

    @ApiModelProperty(value = "销售可用库存(共享)")
    private Integer usableSalesShare;

    @ApiModelProperty(value = "在仓库存(共享)")
    private Integer inWarehouseShare;

    @ApiModelProperty(value = "在仓库存(私有)")
    private Integer inWarehousePrivate;

    @ApiModelProperty(value = "在仓库存(聚合)")
    private Integer inWarehouse;

    @ApiModelProperty(value = "仓库占用(共享)")
    private Integer occupyStockShare;

    @ApiModelProperty(value = "仓库占用(私有)")
    private Integer occupyStockPrivate;

    @ApiModelProperty(value = "仓库占用(聚合)")
    private Integer occupyStock;

    @ApiModelProperty(value = "活动占用")
    private Integer occupyActivity;

    @ApiModelProperty(value = "订单占用(私有)")
    private Integer occupyOrderPrivate;

    @ApiModelProperty(value = "订单占用(共享)")
    private Integer occupyOrderShare;

    @ApiModelProperty(value = "订单占用(聚合)")
    private Integer occupyOrder;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "环球创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "环球更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "已发货库存")
    private Integer shippedStock;

    @ApiModelProperty(value = "中文名称")
    private String skuTitleCn;

    @ApiModelProperty(value = "内部编码")
    private String productInnerCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppliersName;

    @ApiModelProperty(value = "公司Id, 默认0是无意义的")
    private Integer companyId;

    private String bailunSkuWarehouseCode;

    @ApiModelProperty(value = "首次入库时间")
    private LocalDateTime firstInboundDate;

    @ApiModelProperty(value = "数据特性")
    private String character;

    private String bailunSkuWarehouseArea;

    @ApiModelProperty(value = "最近30天支出金额")
    private BigDecimal payAmount30;

    @ApiModelProperty(value = "最近30天收入金额")
    private BigDecimal incomeAmount30;

    @ApiModelProperty(value = "可售天数")
    private BigDecimal availableDays;


}
