package com.bailuntec.job;


import com.bailuntec.job.service.SyncPurchaseDetailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class SyncPurchaseDetailsJob {

    @Resource
    SyncPurchaseDetailService syncPurchaseDetailService;

    @Scheduled(cron = "0/10 * * * * ?")
    public void baseSyncFinanceFee() {
        try {
            log.info("每分钟 同步采购单sku详细信息 开始");
            syncPurchaseDetailService.syncPurchaseDetails();
            log.info("每分钟 同步采购单sku详细信息 结束");
        } catch (Exception ex) {
            log.error("每分钟 同步采购单sku详细信息 异常:", ex);
        }
    }


}
