package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 其他采购单基础表（对应费用系统）
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseBuy对象", description="其他采购单基础表（对应费用系统）")
public class DcBaseBuy implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "采购计划单号")
    private String no;

    @ApiModelProperty(value = "采购单号")
    private String buyno;

    @ApiModelProperty(value = "采购单状态，-2：已拆单，-1：作废，0：采购员未确认，1：采购员确认，2：主管审核，3：发货入库中，4：采购完成，5：待出纳审核，6：出纳未付款")
    private Integer buystatus;

    @ApiModelProperty(value = "付款主体名称")
    private String paycompanyname;

    @ApiModelProperty(value = "sku 编号")
    private String skucode;

    @ApiModelProperty(value = "sku标题")
    private String skuname;

    @ApiModelProperty(value = "预计到货日期")
    private LocalDate arrivaldate;

    @ApiModelProperty(value = "接收货物仓库code")
    private String warehouseid;

    @ApiModelProperty(value = "接收货物仓库名称")
    private String warehousename;

    @ApiModelProperty(value = "付款主体value")
    private Integer paycompanyid;

    @ApiModelProperty(value = "供应商id")
    private Integer supplierid;

    @ApiModelProperty(value = "供应商名称")
    private String suppliername;

    @ApiModelProperty(value = "付款类型,1先款后货，2先货后款，3无需付款")
    private Integer paytype;

    @ApiModelProperty(value = "采购总金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "实际支付总金额")
    private BigDecimal payamount;

    @ApiModelProperty(value = "采购总数量")
    private Integer count;

    @ApiModelProperty(value = "快递费")
    private BigDecimal expressfee;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createtime;

    @ApiModelProperty(value = "最后操作人id")
    private Integer lastupdateuserid;

    @ApiModelProperty(value = "最后操作人名称")
    private String lastupdateusername;

    @ApiModelProperty(value = "最后更新时间")
    private LocalDateTime lastupdatetime;

    @ApiModelProperty(value = "采购员id")
    private Integer buyuserid;

    @ApiModelProperty(value = "付款状态，0：未付款，1：部分付款，2：已付款，3无需付款")
    private Integer paystatus;

    @ApiModelProperty(value = "发货状态，0：未发货，1：部分发货，2：全部发货")
    private Integer sendstatus;

    @ApiModelProperty(value = "创建人id")
    private Integer createuserid;

    @ApiModelProperty(value = "创建人名称")
    private String createusername;

    @ApiModelProperty(value = "订单号")
    private String orderno;

    @ApiModelProperty(value = "采购单备注")
    private String note;

    @ApiModelProperty(value = "是否删除，0：未删除，1：已删除")
    private Integer delstatus;

    @ApiModelProperty(value = "是否紧急，0：常规，1：紧急")
    private Integer isurgency;

    @ApiModelProperty(value = "采购员名称")
    private String buyusername;

    @ApiModelProperty(value = "附件id")
    private Integer fileid;

    @ApiModelProperty(value = "附件保存路径")
    private String filepath;

    @ApiModelProperty(value = "部门id")
    private Integer departmentid;

    @ApiModelProperty(value = "部门名称")
    private String departmentname;

    @ApiModelProperty(value = "审核人id")
    private Integer audituserid;

    @ApiModelProperty(value = "审核人名称")
    private String auditusername;

    @ApiModelProperty(value = "审核时间")
    private LocalDateTime audittime;

    @ApiModelProperty(value = "审核备注")
    private String auditnote;

    @ApiModelProperty(value = "采购主体")
    private String company;

    @ApiModelProperty(value = "供应商编号")
    private String supplierNo;

    @ApiModelProperty(value = "驳回理由")
    private String rejectReason;

    @ApiModelProperty(value = "出纳系统 detailKey")
    private String detailKey;

    private String linkLendCostNo;

    @ApiModelProperty(value = "供应商银行")
    private String supplierBankname;

    @ApiModelProperty(value = "供应商银行卡号")
    private String supplierCardno;

    @ApiModelProperty(value = "供应商持卡人")
    private String supplierCardusername;

    @ApiModelProperty(value = "付款时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "SKU大类名称")
    private String skuTypeName;

    @ApiModelProperty(value = "采购公司主体value")
    private Integer companyValue;

    @ApiModelProperty(value = "统计的数据日期")
    private LocalDate day;


}
