# 新数据中心java同步服务
新数据中心同步服务

## 一、如何使用

### 1.1 项目架构
k8s集群: bailun/data-center-job  
datacenter-task: spring-cloud-data-flow + spring batch  
datacenter-job:  spring schedule  
datacenter-domain: 领域模块  


### 1.2 主要三方库
- springboot 
- mybatis
- mybatis plus 

### 1.3 部署环境
- 子账号k8s集群 bailun/data-center-job deployment名称同镜像名称
- 镜像名称见pom.xml 

```xml
<imageName>ccr.ccs.tencentyun.com/blt.data.job/ebay-report-produce:latest</imageName>
```
 
## 二、项目结构
```
├── data-api
│   ├── src
│   └── target
├── data-base
│   ├── base-sync-amazon-ad
│   ├── base-sync-cashier
│   ├── base-sync-company
│   ├── base-sync-cost-first
│   ├── base-sync-crm-refund
│   ├── base-sync-finance-ebay
│   ├── base-sync-finance-fee
│   ├── base-sync-finance-wish
│   ├── base-sync-oms-order
│   ├── base-sync-paypal
│   ├── base-sync-purchase
│   ├── base-sync-purchase-details
│   ├── base-sync-semi-order
│   ├── base-sync-shopify
│   ├── base-sync-sku
│   ├── base-sync-stock-wms
│   ├── base-sync-transfer
│   └── base-sync-warehouse
├── data-common
│   ├── src
│   └── target
├── data-finance
│   ├── finance-accounting-entry
│   └── finance-balance-sheet
├── data-mid
│   ├── mid-auto-turnover-prepare
│   ├── mid-calculate-cost-first
│   ├── mid-calculate-item
│   ├── mid-calculate-sales
│   ├── mid-calculate-transit
│   ├── mid-daily-stock
│   ├── mid-duration-stock
│   ├── mid-ebay-uk-report
│   └── mid-fba-fee-avg
├── data-show
│   └── show-auto-turnover
├── log
└── target
    └── classes

```
