package com.bailuntec.job;


import com.bailuntec.job.service.DailySnapshotService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class DailySnapshotJob {

    @Resource
    DailySnapshotService dailySnapshotService;

    @Scheduled(cron = "0 10 0 * * ?")
    public void saveDcBastStockDailySnapshot() {
        try {
            log.info("每天10点保存每日库存快照 开始");
            dailySnapshotService.saveDcBastStockDailySnapshot();
            log.info("每天10点保存每日库存快照 结束");
        } catch (Exception ex) {
            log.error("每天10点保存每日库存快照 异常:", ex);
        }
    }

    @Scheduled(cron = "0 10 0 * * ?")
    public void saveDcBaseOmsSku30SnapShot() {
        try {
            log.info("每天10点保存30天oms_sku 开始");
            dailySnapshotService.saveDcBaseOmsSku30SnapShot();
            log.info("每天10点保存30天oms_sku 结束");
        } catch (Exception ex) {
            log.error("每天10点保存30天oms_sku 异常:", ex);
        }
    }

    @Scheduled(cron = "0 10 0 * * ?")
    public void saveMidTransitSnapShot() {
        try {
            log.info("每天1点保存bailunSku-warehouseCode在途数量采购数量缺货数量代发货数量快照 开始");
            dailySnapshotService.saveMidTransitSnapShot();
            log.info("每天1点保存bailunSku-warehouseCode在途数量采购数量缺货数量代发货数量快照 结束");
        } catch (Exception ex) {
            log.error("每天1点保存bailunSku-warehouseCode在途数量采购数量缺货数量代发货数量快照 异常:", ex);
        }
    }

}
