package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceInterest对象", description="")
public class DcBaseFinanceInterest implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "借款id")
    private Integer borrowId;

    @ApiModelProperty(value = "还款id")
    private Integer repayId;

    @ApiModelProperty(value = "合同编码")
    private String contractNo;

    @ApiModelProperty(value = "公司值")
    private Integer companyVal;

    @ApiModelProperty(value = "公司名称")
    private String company;

    @ApiModelProperty(value = "银行卡号")
    private String bankCard;

    @ApiModelProperty(value = "银行卡用户")
    private String bankCardUser;

    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @ApiModelProperty(value = "债权人")
    private String creditor;

    @ApiModelProperty(value = "偿还利息")
    private BigDecimal repayInterest;

    @ApiModelProperty(value = "偿还利息人民币")
    private BigDecimal repayInterestRmb;

    @ApiModelProperty(value = "实际时间")
    private LocalDateTime actualRepayTime;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心修改时间")
    private LocalDateTime gmtModify;


}
