package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ebay费用详情表 gmt_date、item_id、account_entry_type、ref_number作为唯一键
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceEbay对象", description="ebay费用详情表 gmt_date、item_id、account_entry_type、ref_number作为唯一键")
public class DcBaseFinanceEbay implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime bjCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime bjModified;

    @ApiModelProperty(value = "费用类型")
    private String accountEntryType;

    @ApiModelProperty(value = "费用描述")
    private String description;

    @ApiModelProperty(value = "费用产生时间,以GMT格式指示条目过帐到帐户的日期和时间")
    private LocalDateTime gmtDate;

    @ApiModelProperty(value = "费用产生时间,以GMT+8格式指示条目过帐到帐户的日期和时间")
    private LocalDateTime bjDate;

    @ApiModelProperty(value = "ebay评估的总费用,包括净费用和增值税")
    private BigDecimal grossAmount;

    @ApiModelProperty(value = "item id")
    private String itemId;

    @ApiModelProperty(value = "费用条目的备注行")
    private String memo;

    @ApiModelProperty(value = "ebay评估的净费用")
    private BigDecimal netAmount;

    @ApiModelProperty(value = "帐户条目的唯一标识符")
    private String refNumber;

    @ApiModelProperty(value = "计算交易增值税（增值税）的适用税率")
    private BigDecimal vatPercent;

    @ApiModelProperty(value = "eBay用户帐户的货币交易或管理操作的描述或评论")
    private String title;

    @ApiModelProperty(value = "eBay订单行项目的唯一标识符")
    private String orderLineId;

    @ApiModelProperty(value = "订单行项目的唯一标识符")
    private String transactionId;

    @ApiModelProperty(value = "公司id")
    private Integer companyId;

    @ApiModelProperty(value = "是否有顶级折扣")
    private Boolean receivedTopRatedDiscount;

    @ApiModelProperty(value = "账号ID")
    private Integer accountId;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "转人民币汇率,根据bj_date取值")
    private BigDecimal exchangeRate;

    @ApiModelProperty(value = "转美元汇率")
    private BigDecimal exchangeRateUsd;

    private LocalDate reportDate;


}
