package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcOtherCost;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.time.LocalDate;

/**
 * <p>
 * 其他费用(其他应收款和其他应付款) Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcOtherCostMapper extends BaseMapper<DcOtherCost> {

    /**
     * 应收款
     *
     * @param date date
     */
    void insertOneDayOtherReceive(LocalDate date);

    /**
     * 应付款
     *
     * @param date date
     */
    void insertOneDayOtherPay(LocalDate date);

    /**
     * 清空指定日期的
     *
     * @param date date
     */
    void clearOneDay(LocalDate date);
}
