package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in 11:20 2021-03-29
 * @Modified by:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcSemiStockLog对象", description = "")
public class DcSemiStockLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("流水ID")
    private Integer logId;

    @ApiModelProperty("原料sku编码")
    private String skuCode;

    @ApiModelProperty("原料sku名称")
    private String skuName;

    @ApiModelProperty("流水类型ID")
    private Integer logTypeId;

    @ApiModelProperty("流水类型名称")
    private String logType;

    @ApiModelProperty("流水数量")
    private Integer logQuantity;

    @ApiModelProperty("当前库存")
    private BigDecimal finalStock;

    @ApiModelProperty("仓库ID")
    private Integer warehouseId;

    @ApiModelProperty("仓库名称")
    private String warehouseName;

    @ApiModelProperty("半成品仓流水创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("冗余库存")
    private BigDecimal redundancyStock;

    @ApiModelProperty("仓库类型:1-jit仓，2-计划仓")
    private Integer warehouseType;

    @ApiModelProperty("取数时间")
    private LocalDateTime updateTime;

    @ApiModelProperty("产品大类id")
    private Integer productCategoryId;

    @ApiModelProperty("产品大类")
    private String productCategoryName;

    @ApiModelProperty("产品小类id")
    private Integer TypeId;

    @ApiModelProperty("产品小类")
    private String typeName;
}
