package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 百伦OMS订单-配货信息
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseOmsPick对象", description="百伦OMS订单-配货信息")
public class DcBaseOmsPick implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "平台订单号")
    private String originOrderId;

    @ApiModelProperty(value = "账号id")
    private Integer bailunAccountId;

    @ApiModelProperty(value = "百伦订单号")
    private String bailunOrderId;

    @ApiModelProperty(value = "配货单号")
    private String pickOrderId;

    @ApiModelProperty(value = "追踪提供商")
    private String trackingProvider;

    @ApiModelProperty(value = "追踪单号")
    private String trackingOrderId;

    @ApiModelProperty(value = "百伦发货状态")
    private String shippingStatus;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "发货时间")
    private LocalDateTime shippingTime;

    @ApiModelProperty(value = "百伦SKU仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "百伦SKU仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "运单号")
    private String logisticsOrderId;

    @ApiModelProperty(value = "运单线路")
    private String logisticsOrderName;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "配货数量")
    private Integer quantityPicked;

    @ApiModelProperty(value = "发货数量")
    private Integer quantityShipped;

    @ApiModelProperty(value = "百伦sku")
    private String bailunSku;

    @ApiModelProperty(value = "申报价值,USD")
    private BigDecimal declarePrice;

    @ApiModelProperty(value = "运费-配货单维度")
    private BigDecimal costShipping;

    @ApiModelProperty(value = "包装费-配货单维度")
    private BigDecimal costPackaging;

    @ApiModelProperty(value = "出库重量,KG-配货单维度")
    private BigDecimal outboundWeight;

    @ApiModelProperty(value = "运费-SKU维度")
    private BigDecimal bailunSkuCostShipping;

    @ApiModelProperty(value = "包装费-SKU维度")
    private BigDecimal bailunSkuCostPackaging;

    @ApiModelProperty(value = "出库重量,G-SKU维度")
    private BigDecimal bailunSkuOutboundWeight;

    @ApiModelProperty(value = "是否被删除-数据中心添加")
    private Boolean hasDelete;

    @ApiModelProperty(value = "公司Id, 默认0是无意义的")
    private Integer companyId;

    @ApiModelProperty(value = "是否推送第三方仓库")
    private Boolean hasPushed;

    @ApiModelProperty(value = "总费用")
    private BigDecimal totalFee;

    @ApiModelProperty(value = "运输费")
    private BigDecimal shipping;

    @ApiModelProperty(value = "操作费")
    private BigDecimal opf;

    @ApiModelProperty(value = "燃油附加费")
    private BigDecimal fsc;

    @ApiModelProperty(value = "关税")
    private BigDecimal dt;

    @ApiModelProperty(value = "挂号")
    private BigDecimal rsf;

    @ApiModelProperty(value = "其他费用")
    private BigDecimal otf;

    @ApiModelProperty(value = "仓租")
    private BigDecimal whf;

    @ApiModelProperty(value = "币种")
    private String currencyCode;

    @ApiModelProperty(value = "转人民币-汇率")
    private BigDecimal wmsToCnyExchangeRate;

    @ApiModelProperty(value = "转美元-汇率")
    private BigDecimal wmsToUsdExchangeRate;


}
