package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 来自CRM的订单退款费用
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseCrmRefund对象", description="来自CRM的订单退款费用")
public class DcBaseCrmRefund implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "平台类型")
    private String platformType;

    @ApiModelProperty(value = "百伦账号")
    private String bailunAccount;

    @ApiModelProperty(value = "百伦账号id")
    private Integer bailunAccountId;

    @ApiModelProperty(value = "站点")
    private String website;

    @ApiModelProperty(value = "平台订单号")
    private String originOrderId;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "平台SKU")
    private String platformSku;

    @ApiModelProperty(value = "退款金额-原币种")
    private BigDecimal amountRefund;

    @ApiModelProperty(value = "订单币种")
    private String orderCurrency;

    @ApiModelProperty(value = "订单退款时间")
    private LocalDateTime refundTime;

    @ApiModelProperty(value = "百伦SKU退货数量")
    private Integer bailunSkuQuantityRefund;

    @ApiModelProperty(value = "百伦SKU单价")
    private BigDecimal bailunSkuUnitPrice;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "是否与订单关联")
    private Boolean linked;

    @ApiModelProperty(value = "退款转人民币")
    private BigDecimal amountRefundRmb;

    @ApiModelProperty(value = "CRM的唯一主键")
    private Integer crmId;

    @ApiModelProperty(value = "退款转美元")
    private BigDecimal amountRefundUsd;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "订单总金额(本币)")
    private BigDecimal orderTotalAmount;

    @ApiModelProperty(value = "订单总金额(美金)")
    private BigDecimal usdOrderTotalAmount;

    @ApiModelProperty(value = "sku总售价(美金)")
    private BigDecimal productSaleAmount;

    @ApiModelProperty(value = "是否删除")
    private Boolean isDeleted;

    @ApiModelProperty(value = "是否冻结")
    private Boolean isFreeze;

    @ApiModelProperty(value = "订单状态")
    private String orderStatus;

    @ApiModelProperty(value = "发货状态")
    private String shippingStatus;

    @ApiModelProperty(value = "是否平台退款")
    private String refundType;


}
