package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 资产负债表,RMB
 * </p>
 *
 * @author robbendev
 * @since 2020-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBalanceSheetNew对象", description = "资产负债表,RMB")
public class DcBalanceSheetNew implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @JsonProperty("company_value")
    @ApiModelProperty(value = "公司主体value")
    private Integer companyValue;

    @JsonProperty("company_name")
    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @JsonProperty("monetary_fund")
    @ApiModelProperty(value = "货币资金")
    private BigDecimal monetaryFund;

    @JsonProperty("bank_account_balance")
    @ApiModelProperty(value = "银行账号余额")
    private BigDecimal bankAccountBalance;

    @JsonProperty("withdraw_amount")
    @ApiModelProperty(value = "提现在途金额")
    private BigDecimal withdrawAmount;

    @JsonProperty("platform_balance")
    @ApiModelProperty(value = "第三方平台余额")
    private BigDecimal platformBalance;

    @JsonProperty("accounts_receivable")
    @ApiModelProperty(value = "应收账款")
    private BigDecimal accountsReceivable;

    @JsonProperty("amount_borrowed")
    @ApiModelProperty(value = "借支金额")
    private BigDecimal amountBorrowed;

    @JsonProperty("prepayment")
    @ApiModelProperty(value = "预付款项")
    private BigDecimal prepayment;

    @JsonProperty("logistics_prepayment")
    @ApiModelProperty(value = "物流供应商预付款项")
    private BigDecimal logisticsPrepayment;

    @JsonProperty("finished_prepayment")
    @ApiModelProperty(value = "成品供应商预付款项")
    private BigDecimal finishedPrepayment;

    @JsonProperty("semi_prepayment")
    @ApiModelProperty(value = "半成品供应商预付款项")
    private BigDecimal semiPrepayment;

    @JsonProperty("other_accounts_receivable")
    @ApiModelProperty(value = "其他应收款")
    private BigDecimal otherAccountsReceivable;

    @JsonProperty("inventory_amount")
    @ApiModelProperty(value = "存货余额/库存金额")
    private BigDecimal inventoryAmount;

    @JsonProperty("fbaInventory_amount")
    @ApiModelProperty(value = "FBA库存金额")
    private BigDecimal fbaInventoryAmount;

    @JsonProperty("not_fba_inventory_amount")
    @ApiModelProperty(value = "非FBA库存金额")
    private BigDecimal notFbaInventoryAmount;

    @JsonProperty("not_fba_hc_inventory_amount")
    @ApiModelProperty(value = "非FBA耗材库存金额")
    private BigDecimal notFbaHcInventoryAmount;

    @JsonProperty("fba_transfer_amount")
    @ApiModelProperty(value = "FBA在途金额(调拨+采购)")
    private BigDecimal fbaTransferAmount;

    @JsonProperty("not_fba_transfer_amount")
    @ApiModelProperty(value = "非FBA在途金额(调拨+采购)")
    private BigDecimal notFbaTransferAmount;

    @JsonProperty("fba_transfer_allot_amount")
    @ApiModelProperty(value = "FBA在途金额(调拨不包含计划)")
    private BigDecimal fbaTransferAllotAmount;

    @JsonProperty("not_fba_transfer_allot_amount")
    @ApiModelProperty(value = "非FBA在途金额(调拨不包含计划)")
    private BigDecimal notFbaTransferAllotAmount;

    @JsonProperty("fba_transfer_plan_amount")
    @ApiModelProperty(value = "FBA在途金额(调拨计划)")
    private BigDecimal fbaTransferPlanAmount;

    @JsonProperty("not_fba_transfer_plan_amount")
    @ApiModelProperty(value = "非FBA在途金额(调拨计划)")
    private BigDecimal notFbaTransferPlanAmount;

    @JsonProperty("fba_purchase_amount")
    @ApiModelProperty(value = "FBA在途金额(采购)")
    private BigDecimal fbaPurchaseAmount;

    @JsonProperty("not_fba_purchase_amount")
    @ApiModelProperty(value = "非FBA在途金额(采购)")
    private BigDecimal notFbaPurchaseAmount;

    @JsonProperty("purchase_pro_amount")
    @ApiModelProperty(value = "生产采购发货在途金额")
    private BigDecimal purchaseProAmount;

    @JsonProperty("semi_inventory_amount")
    @ApiModelProperty(value = "半成品在库金额")
    private BigDecimal semiInventoryAmount;

    @JsonProperty("semi_transfer_amount")
    @ApiModelProperty(value = "半成品在途金额")
    private BigDecimal semiTransferAmount;

    @JsonProperty("semi_bailun_inventory_amount")
    @ApiModelProperty(value = "百伦半成品在库金额")
    private BigDecimal semiBailunInventoryAmount;

    @JsonProperty("semi_hani_inventory_amount")
    @ApiModelProperty(value = "哈尼曼半成品在库金额")
    private BigDecimal semiHaniInventoryAmount;

    @JsonProperty("semi_bailun_transfer_amount")
    @ApiModelProperty(value = "百伦半成品在途金额")
    private BigDecimal semiBailunTransferAmount;

    @JsonProperty("semi_hani_transfer_amount")
    @ApiModelProperty(value = "哈尼曼半成品在途金额")
    private BigDecimal semiHaniTransferAmount;

    @JsonProperty("semi_prod_inventory_amount")
    @ApiModelProperty(value = "半成品生产在库金额")
    private BigDecimal semiProdInventoryAmount;

    @JsonProperty("fixed_assets")
    @ApiModelProperty(value = "固定资产")
    private BigDecimal fixedAssets;

    @JsonProperty("short_term_borrow")
    @ApiModelProperty(value = "短期借款")
    private BigDecimal shortTermBorrow;

    @JsonProperty("accounts_payable")
    @ApiModelProperty(value = "应付账款")
    private BigDecimal accountsPayable;

    @JsonProperty("logistics_accounts_payable")
    @ApiModelProperty(value = "物流供应商应付账款")
    private BigDecimal logisticsAccountsPayable;

    @JsonProperty("finished_accounts_payable")
    @ApiModelProperty(value = "成品供应商应付账款")
    private BigDecimal finishedAccountsPayable;

    @JsonProperty("semi_accounts_payable")
    @ApiModelProperty(value = "半成品供应商应付账款")
    private BigDecimal semiAccountsPayable;

    @JsonProperty("advance_received")
    @ApiModelProperty(value = "预收款项")
    private BigDecimal advanceReceived;

    @JsonProperty("payable_remuneration")
    @ApiModelProperty(value = "应付职工薪酬")
    private BigDecimal payableRemuneration;

    @JsonProperty("taxes_payable")
    @ApiModelProperty(value = "应交税费")
    private BigDecimal taxesPayable;

    @JsonProperty("other_accounts_payable")
    @ApiModelProperty(value = "其他应付款")
    private BigDecimal otherAccountsPayable;

    @JsonProperty("longTerm_accounts_payable")
    @ApiModelProperty(value = "长期应付款")
    private BigDecimal longTermAccountsPayable;

    @JsonProperty("statistical_time")
    @ApiModelProperty(value = "统计时间")
    private LocalDate statisticalTime;

    @ApiModelProperty(value = "取数时间")
    @JsonProperty("update_time")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "（流动资产）交易性金融资金")
    @JsonProperty("fa_trading_finan_asset")
    private BigDecimal faTradingFinanAsset;

    @ApiModelProperty(value = "应收票据")
    @JsonProperty("fa_bill_receivable")
    private BigDecimal faBillReceivable;

    @ApiModelProperty(value = "应收利息")
    @JsonProperty("fa_interest_receivable")
    private BigDecimal faInterestReceivable;

    @ApiModelProperty(value = "应收股利")
    @JsonProperty("fa_dividends_receivable")
    private BigDecimal faDividendsReceivable;

    @ApiModelProperty(value = "一年内到期的非流动资产")
    @JsonProperty("fa_oneyear_noncurrent_assets")
    private BigDecimal faOneyearNoncurrentAssets;

    @ApiModelProperty(value = "其他流动资产")
    @JsonProperty("fa_other_assets")
    private BigDecimal faOtherAssets;

    @ApiModelProperty(value = "流动资产合计")
    @JsonProperty("fa_count")
    private BigDecimal faCount;

    @ApiModelProperty(value = "可供出售金融资产")
    @JsonProperty("nca_avai_forSale_fassets")
    private BigDecimal ncaAvaiForSaleFassets;

    @ApiModelProperty(value = "持有至到期的投资")
    @JsonProperty("nca_heldon_investment")
    private BigDecimal ncaHeldonInvestment;

    @ApiModelProperty(value = "长期应收款")
    @JsonProperty("nca_longterm_receivable")
    private BigDecimal ncaLongtermReceivable;

    @JsonProperty("nca_longterm_equity_investment")
    @ApiModelProperty(value = "长期股权投资")
    private BigDecimal ncaLongtermEquityInvestment;

    @JsonProperty("nca_investment_property")
    @ApiModelProperty(value = "投资性房地产")
    private BigDecimal ncaInvestmentProperty;

    @JsonProperty("nca_construction_in_process")
    @ApiModelProperty(value = "在建工程")
    private BigDecimal ncaConstructionInProcess;

    @JsonProperty("nca_engineering_material")
    @ApiModelProperty(value = "工程物资")
    private BigDecimal ncaEngineeringMaterial;

    @JsonProperty("nca_disposal_of_fixed_assets")
    @ApiModelProperty(value = "固定资产清理")
    private BigDecimal ncaDisposalOfFixedAssets;

    @JsonProperty("nca_productive_biological_asset")
    @ApiModelProperty(value = "生产性生物资产")
    private BigDecimal ncaProductiveBiologicalAsset;

    @JsonProperty("nca_oil_and_gas_assets")
    @ApiModelProperty(value = "油气资产")
    private BigDecimal ncaOilAndGasAssets;

    @JsonProperty("nca_intangible_assets")
    @ApiModelProperty(value = "无形资产")
    private BigDecimal ncaIntangibleAssets;

    @JsonProperty("nca_development_expenditure")
    @ApiModelProperty(value = "开发支出")
    private BigDecimal ncaDevelopmentExpenditure;

    @JsonProperty("nca_goodwill")
    @ApiModelProperty(value = "商誉")
    private BigDecimal ncaGoodwill;

    @JsonProperty("nca_longterm_unamortized_expenses")
    @ApiModelProperty(value = "长期待摊费用")
    private BigDecimal ncaLongtermUnamortizedExpenses;

    @JsonProperty("nca_deferred_tax_assets")
    @ApiModelProperty(value = "递延所得税资产")
    private BigDecimal ncaDeferredTaxAssets;

    @JsonProperty("nca_other_assets")
    @ApiModelProperty(value = "其他非流动资产")
    private BigDecimal ncaOtherAssets;

    @JsonProperty("nca_count")
    @ApiModelProperty(value = "非流动资产合计")
    private BigDecimal ncaCount;

    @JsonProperty("count_assets")
    @ApiModelProperty(value = "资产合计")
    private BigDecimal countAssets;

    @JsonProperty("cl_trading_financ_liabilities")
    @ApiModelProperty(value = "交易性金融负债")
    private BigDecimal clTradingFinancLiabilities;

    @JsonProperty("cl_notes_payable")
    @ApiModelProperty(value = "应付票据")
    private BigDecimal clNotesPayable;

    @JsonProperty("cl_payable_interest")
    @ApiModelProperty(value = "应付利息")
    private BigDecimal clPayableInterest;

    @JsonProperty("cl_dividends_payable")
    @ApiModelProperty(value = "应付股利")
    private BigDecimal clDividendsPayable;

    @JsonProperty("cl_oneyear_noncurrent_liabilities")
    @ApiModelProperty(value = "一年内到期的非流动负债")
    private BigDecimal clOneyearNoncurrentLiabilities;

    @JsonProperty("cl_other_liabilities")
    @ApiModelProperty(value = "其他流动负债")
    private BigDecimal clOtherLiabilities;

    @JsonProperty("cl_count")
    @ApiModelProperty(value = "流动负债合计")
    private BigDecimal clCount;

    @JsonProperty("ncl_longterm_loan")
    @ApiModelProperty(value = "长期借款")
    private BigDecimal nclLongtermLoan;

    @JsonProperty("ncl_bonds_payable")
    @ApiModelProperty(value = "应付债券")
    private BigDecimal nclBondsPayable;

    @JsonProperty("ncl_special_payable")
    @ApiModelProperty(value = "专项应付款")
    private BigDecimal nclSpecialPayable;

    @JsonProperty("ncl_anticipation_liabilities")
    @ApiModelProperty(value = "预计负债")
    private BigDecimal nclAnticipationLiabilities;

    @JsonProperty("ncl_deferred_income_tax_liabilities")
    @ApiModelProperty(value = "递延所得税负债")
    private BigDecimal nclDeferredIncomeTaxLiabilities;

    @JsonProperty("ncl_other_liabilities")
    @ApiModelProperty(value = "其他非流动负债")
    private BigDecimal nclOtherLiabilities;

    @JsonProperty("ncl_count")
    @ApiModelProperty(value = "非流动负债合计")
    private BigDecimal nclCount;

    @JsonProperty("count_liabilities")
    @ApiModelProperty(value = "负债合计")
    private BigDecimal countLiabilities;

    @JsonProperty("oe_paicl_up_capital")
    @ApiModelProperty(value = "实收资本")
    private BigDecimal oePaiclUpCapital;

    @ApiModelProperty(value = "资本公积")
    @JsonProperty("oe_capital_reserve")
    private BigDecimal oeCapitalReserve;

    @ApiModelProperty(value = "(减)库存额")
    @JsonProperty("oe_inventory_amount")
    private BigDecimal oeInventoryAmount;

    @JsonProperty("oe_surplus_public_accumulation")
    @ApiModelProperty(value = "盈余公积")
    private BigDecimal oeSurplusPublicAccumulation;

    @JsonProperty("oe_undistributed_profit")
    @ApiModelProperty(value = "未分配利润")
    private BigDecimal oeUndistributedProfit;

    @JsonProperty("oe_count")
    @ApiModelProperty(value = "所有者权益合计")
    private BigDecimal oeCount;

    @JsonProperty("count_liabilities_and_oe")
    @ApiModelProperty(value = "负债和所有者权益合计")
    private BigDecimal countLiabilitiesAndOe;

    @JsonProperty("accounts_receivable_update")
    private BigDecimal accountsReceivableUpdate;

    @JsonProperty("accounts_receivable_import")
    @ApiModelProperty(value = "应收款项-导入")
    private BigDecimal accountsReceivableImport;

    @JsonProperty("other_accounts_receivable_import")
    @ApiModelProperty(value = "其他应收款项-导入")
    private BigDecimal otherAccountsReceivableImport;

    @JsonProperty("otherAccounts_payable_import")
    @ApiModelProperty(value = "其他应付-导入")
    private BigDecimal otherAccountsPayableImport;

    @JsonProperty("fixed_assets_import")
    @ApiModelProperty(value = "固定资产-导入")
    private BigDecimal fixedAssetsImport;

    @ApiModelProperty(value = "递延所得税资产-导入")
    @JsonProperty("nca_deferred_taxAssets_import")
    private BigDecimal ncaDeferredTaxAssetsImport;


}
