package com.bailuntec.application.impl;

import com.bailuntec.application.IDcAutoMonitorSkuTypeService;
import com.bailuntec.application.IDcBaseStockService;
import com.bailuntec.domain.DcAutoMonitorSkuType;
import com.bailuntec.domain.DcBaseStock;
import com.bailuntec.domain.DcBaseWarehouse;
import com.bailuntec.infrastructure.mapper.DcAutoMonitorSkuTypeMapper;
import com.bailuntec.infrastructure.mapper.DcBaseStockMapper;
import com.bailuntec.infrastructure.mapper.DcBaseWarehouseMapper;
import com.bailuntec.pojo.WmsStockItem;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 * 实时环球库存信息表 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Service
@Slf4j
public class DcBaseStockServiceImpl extends ServiceImpl<DcBaseStockMapper, DcBaseStock> implements IDcBaseStockService {

    @Resource
    DcBaseStockMapper mapper;
    @Resource
    DcBaseWarehouseMapper dcBaseWarehouseMapper;
    @Resource
    DcAutoMonitorSkuTypeMapper dcAutoMonitorSkuTypeMapper;
    @Resource
    IDcAutoMonitorSkuTypeService dcAutoMonitorSkuTypeService;

    @Override
    public void syncWmsStock(WmsStockItem wmsStockItem) {
        try {

            DcBaseStock dcBaseStock = new DcBaseStock();
            //BeanUtils.copyProperties(dcBaseStock, wmsStockItem);
            dcBaseStock.setBailunSku(wmsStockItem.getBailunSku());
            dcBaseStock.setWarehouseCode(wmsStockItem.getWarehouseCode());
            dcBaseStock.setWaitPutaway(wmsStockItem.getWaitPutaway());
            dcBaseStock.setOccupyStock(wmsStockItem.getOccupyStock());
            dcBaseStock.setQuantityFreeze(wmsStockItem.getQuantityFreeze());
            dcBaseStock.setQuantityTransit(wmsStockItem.getQuantityTransit());
            dcBaseStock.setShippedStock(wmsStockItem.getShippedStock());
            dcBaseStock.setUsableStock(wmsStockItem.getUsableStock());
            dcBaseStock.setUpdateTime(wmsStockItem.getUpdateTime());
            int i = mapper.update(dcBaseStock, new LambdaQueryWrapper<DcBaseStock>()
                    .eq(DcBaseStock::getBailunSku, dcBaseStock.getBailunSku())
                    .eq(DcBaseStock::getWarehouseCode, dcBaseStock.getWarehouseCode()));
            if (i == 0) {
                try {
                    DcBaseWarehouse dcBaseWarehouse = dcBaseWarehouseMapper.selectOne(new LambdaQueryWrapper<DcBaseWarehouse>()
                            .eq(DcBaseWarehouse::getWarehouseCode, dcBaseStock.getWarehouseCode()));
                    if (dcBaseWarehouse != null) {
                        DcAutoMonitorSkuType dcAutoMonitorSkuType = new DcAutoMonitorSkuType();
                        dcAutoMonitorSkuType.setBailunSku(dcBaseStock.getBailunSku());
                        dcAutoMonitorSkuType.setWarehouseType(dcBaseWarehouse.getHqType());
                        dcAutoMonitorSkuTypeService.saveOrUpdate(dcAutoMonitorSkuType, new LambdaQueryWrapper<DcAutoMonitorSkuType>()
                                .eq(DcAutoMonitorSkuType::getBailunSku, dcAutoMonitorSkuType.getBailunSku())
                                .eq(DcAutoMonitorSkuType::getWarehouseType, dcAutoMonitorSkuType.getWarehouseType()));
                    }

                } catch (Exception ignore) {
                    //这里异常可以忽略掉，不影响，只是记录
                }
                mapper.insert(dcBaseStock);
            }
        } catch (Exception ex) {
            log.error(wmsStockItem.getWarehouseCode() + "-" +wmsStockItem.getBailunSku() + "库存同步发生异常：" + ex.getMessage());
            throw ex;
        }
    }
}
