package com.bailuntec.infrastructure.mapper;

import com.bailuntec.api.bailuntec.purchase.resp.SupplierTransactionDTO;
import com.bailuntec.domain.DcSupplierTransaction;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
public interface DcSupplierTransactionMapper extends BaseMapper<DcSupplierTransaction> {

    @Insert("<script>" +
            "insert into dc_supplier_transaction(day,types,is_finish,pay_company_value,pay_company_name,supplier_id,supplier_name,parent_supplier_id,parent_supplier_name," +
            "start_amount,putting_amount,express_amount,pay_amount,return_amount,return_express,receive_amount,adjust_amount,end_amount,delay_no_pay_amount) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.day},#{item.types},#{item.isFinish},#{item.payCompanyValue},#{item.payCompanyName},#{item.supplierId},#{item.supplierName}," +
            "#{item.parentSupplierId},#{item.parentSupplierName},#{item.startAmount},#{item.puttingAmount},#{item.expressAmount},#{item.payAmount},#{item.returnAmount}," +
            "#{item.returnExpress},#{item.receiveAmount},#{item.adjustAmount},#{item.endAmount},#{item.delayNoPayAmount})" +
            "</foreach>" +
            "on duplicate key update types=values(types),is_finish=values(is_finish),pay_company_value=values(pay_company_value),pay_company_name=values(pay_company_name)," +
            "supplier_id=values(supplier_id),supplier_name=values(supplier_name),parent_supplier_id=values(parent_supplier_id),parent_supplier_name=values(parent_supplier_name)," +
            "start_amount=values(start_amount),putting_amount=values(putting_amount),express_amount = values(express_amount),pay_amount = values(pay_amount)," +
            "return_amount = values(return_amount),return_express = values(return_express),receive_amount = values(receive_amount),adjust_amount = values(adjust_amount)," +
            "end_amount = values(end_amount),delay_no_pay_amount = values(delay_no_pay_amount)" +
            "</script>")
    void insertOrUpdateSupplierTransaction(List<SupplierTransactionDTO> dcSupplierTransactions);

    /**
     * 应付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount > 0 and types = 2")
    BigDecimal getAccountsPayableSum(@Param("lastDay") LocalDate lastDay);

    /**
     * 预付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount < 0 and types = 2")
    BigDecimal getPrepaymentSum(@Param("lastDay") LocalDate lastDay);

    /**
     * 成品应付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount > 0 and is_finish = 1 and types = 2")
    BigDecimal getFinishedAccountsPayableSum(@Param("lastDay") LocalDate lastDay);

    @Select("select sum(case when platform not in ('Ebay', 'shopify') then amount_end else 0 end) - sum(case when platform in ('Ebay', 'shopify') then amount_end else 0 end) from dc_daily_receivable where day = #{lastDay}")
    BigDecimal getAccountsReceivable(@Param("lastDay") LocalDate lastDay);

    /**
     * 成品预付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount < 0 and is_finish = 1 and types = 2")
    BigDecimal getFinishedPrepaymentSum(@Param("lastDay") LocalDate lastDay);

    /**
     * 半成品应付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount > 0 and is_finish = 0 and types = 2")
    BigDecimal getSemiAccountsPayableSum(@Param("lastDay") LocalDate lastDay);

    /**
     * 半成品预付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount < 0 and is_finish = 0 and types = 2")
    BigDecimal getSemiPrepaymentSum(@Param("lastDay") LocalDate lastDay);

}
