package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * SKU对应的发货仓库,一对多
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseSkuWarehouse对象", description="SKU对应的发货仓库,一对多")
public class DcBaseSkuWarehouse implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "监控状态, 默认0启用, 1为仓库停用")
    private Integer status;

    @ApiModelProperty(value = "是否默认仓, false为备用仓")
    private Boolean hasDefault;

    @ApiModelProperty(value = "公司Id")
    private Integer companyId;


}
