package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 亚马逊广告费用-平台SKU维度
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceAmazon对象", description="亚马逊广告费用-平台SKU维度")
public class DcBaseFinanceAmazon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "广告系列名称")
    private String campaignName;

    @ApiModelProperty(value = "广告系列唯一ID")
    private String campaignId;

    @ApiModelProperty(value = "广告组名称")
    private String adGroupName;

    @ApiModelProperty(value = "广告组唯一ID")
    private String adGroupId;

    @ApiModelProperty(value = "广告总展示次数")
    private Integer impressions;

    @ApiModelProperty(value = "广告总点击次数")
    private Integer clicks;

    @ApiModelProperty(value = "所有点击总费用")
    private BigDecimal cost;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "ASIN")
    private String asin;

    @ApiModelProperty(value = "平台SKU")
    private String sku;

    @ApiModelProperty(value = "1天内规因转化事件数")
    private Integer attributedConversionsOneday;

    @ApiModelProperty(value = "7天内归因转化事件数")
    private Integer attributedConversionsSevenday;

    @ApiModelProperty(value = "14天内归因转化事件数")
    private Integer attributedConversionsFourteenday;

    @ApiModelProperty(value = "30天内归因转化事件数")
    private Integer attributedConversionsThirtyday;

    private String attributedConversionsOnedaySameSku;

    private String attributedConversionsSevendaySameSku;

    private String attributedConversionsFourteendaySameSku;

    private String attributedConversionsThirtydaySameSku;

    @ApiModelProperty(value = "1天内订购的归属单位数量")
    private Integer attributedUnitsOrderedOneday;

    @ApiModelProperty(value = "7天内订购归属单位数量")
    private Integer attributedUnitsOrderedSevenday;

    @ApiModelProperty(value = "14天内订购归属单位数量")
    private String attributedUnitsOrderedFourteenday;

    @ApiModelProperty(value = "30天内订购归属单位数量")
    private String attributedUnitsOrderedThirtyday;

    @ApiModelProperty(value = "1天内规因销售数量")
    private Integer attributedSalesOneday;

    @ApiModelProperty(value = "7天内归因销售数量")
    private Integer attributedSalesSevenday;

    @ApiModelProperty(value = "14天内归因销售数量")
    private Integer attributedSalesFourteenday;

    @ApiModelProperty(value = "30天内归因销售数量")
    private Integer attributedSalesThirtyday;

    private String attributedSalesOnedaySameSku;

    private String attributedSalesSevendaySameSku;

    private String attributedSalesFourteendaySameSku;

    private String attributedSalesThirtydaySameSku;

    private String attributedUnitsOrderedOnedaySameSku;

    private String attributedUnitsOrderedSevendaySameSku;

    private String attributedUnitsOrderedFourteendaySameSku;

    private String attributedUnitsOrderedThirtydaySameSku;

    @ApiModelProperty(value = "帐号ID")
    private Integer accountId;

    @ApiModelProperty(value = "公司ID")
    private Integer companyId;

    @ApiModelProperty(value = "本地创建时间")
    private LocalDateTime bjCreateTime;

    @ApiModelProperty(value = "本地更新时间")
    private LocalDateTime bjModifyTime;

    @ApiModelProperty(value = "报告日期")
    private LocalDate reportDate;

    @ApiModelProperty(value = "无意义字段")
    private String reportType;

    @ApiModelProperty(value = "转人民币汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty(value = "转美元汇率")
    private BigDecimal exchangeRateUsd;


}
