package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 周转预测断货
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoShortSupply对象", description="周转预测断货")
public class DcAutoShortSupply implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "预测今日断货")
    private BigDecimal forecastTodayShortSupply;

    @ApiModelProperty(value = "预测第一日断货")
    private BigDecimal forecastOnedayShortSupply;

    @ApiModelProperty(value = "预测第二日断货")
    private BigDecimal forecastTwodayShortSupply;

    @ApiModelProperty(value = "预测第三日断货")
    private BigDecimal forecastThreedayShortSupply;

    @ApiModelProperty(value = "预测第四日断货")
    private BigDecimal forecastFourthdayShortSupply;

    @ApiModelProperty(value = "预测第五日断货")
    private BigDecimal forecastFivedayShortSupply;

    @ApiModelProperty(value = "预测第六日断货")
    private BigDecimal forecastSixdayShortSupply;

    @ApiModelProperty(value = "预测第七日断货")
    private BigDecimal forecastSevendayShortSupply;

    @ApiModelProperty(value = "预测第八日断货")
    private BigDecimal forecastEightdayShortSupply;

    @ApiModelProperty(value = "预测第九日断货")
    private BigDecimal forecastNinedayShortSupply;

    @ApiModelProperty(value = "预测第十日断货")
    private BigDecimal forecastTendayShortSupply;

    @ApiModelProperty(value = "预测第十一日断货")
    private BigDecimal forecastElevendayShortSupply;

    @ApiModelProperty(value = "预测第十二日断货")
    private BigDecimal forecastTwelvedayShortSupply;

    @ApiModelProperty(value = "预测第十三日断货")
    private BigDecimal forecastThridteendayShortSupply;

    @ApiModelProperty(value = "预测第十四日断货")
    private BigDecimal forecastFourteendayShortSupply;

    @ApiModelProperty(value = "预测第十五日断货")
    private BigDecimal forecastFifteendayShortSupply;

    @ApiModelProperty(value = "预测第十六日断货")
    private BigDecimal forecastSixteendayShortSupply;

    @ApiModelProperty(value = "预测第十七日断货")
    private BigDecimal forecastSeventeendayShortSupply;

    @ApiModelProperty(value = "预测第十八日断货")
    private BigDecimal forecastEighteendayShortSupply;

    @ApiModelProperty(value = "预测第十九日断货")
    private BigDecimal forecastNineteendayShortSupply;

    @ApiModelProperty(value = "预测第二十日断货")
    private BigDecimal forecastTwentydayShortSupply;

    @ApiModelProperty(value = "预测第二十一日断货")
    private BigDecimal forecastTwentyOnedayShortSupply;

    @ApiModelProperty(value = "预测第二十二日断货")
    private BigDecimal forecastTwentyTwodayShortSupply;

    @ApiModelProperty(value = "预测第二十三日断货")
    private BigDecimal forecastTwentyThreedayShortSupply;

    @ApiModelProperty(value = "预测第二十四日断货")
    private BigDecimal forecastTwentyFourthdayShortSupply;

    @ApiModelProperty(value = "预测第二十五日断货")
    private BigDecimal forecastTwentyFivedayShortSupply;

    @ApiModelProperty(value = "预测第二十六日断货")
    private BigDecimal forecastTwentySixdayShortSupply;

    @ApiModelProperty(value = "预测第二十七日断货")
    private BigDecimal forecastTwentySevenedayShortSupply;

    @ApiModelProperty(value = "预测第二十八日断货")
    private BigDecimal forecastTwentyEightdayShortSupply;

    @ApiModelProperty(value = "预测第二十九日断货")
    private BigDecimal forecastTwentyNinedayShortSupply;

    @ApiModelProperty(value = "预测第三十日断货")
    private BigDecimal forecastThirtydayShortSupply;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "详细数据")
    private String details;


}
