package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 周转预测库存
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoInventory对象", description="周转预测库存")
public class DcAutoInventory implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "实际库存")
    private BigDecimal actualInventory;

    @ApiModelProperty(value = "预测今日库存")
    private BigDecimal forecastTodayInventory;

    @ApiModelProperty(value = "预测第一日库存")
    private BigDecimal forecastOnedayInventory;

    @ApiModelProperty(value = "预测第二日库存")
    private BigDecimal forecastTwodayInventory;

    @ApiModelProperty(value = "预测第三日库存")
    private BigDecimal forecastThreedayInventory;

    @ApiModelProperty(value = "预测第四日库存")
    private BigDecimal forecastFourthdayInventory;

    @ApiModelProperty(value = "预测第五日库存")
    private BigDecimal forecastFivedayInventory;

    @ApiModelProperty(value = "预测第六日库存")
    private BigDecimal forecastSixdayInventory;

    @ApiModelProperty(value = "预测第七日库存")
    private BigDecimal forecastSevendayInventory;

    @ApiModelProperty(value = "预测第八日库存")
    private BigDecimal forecastEightdayInventory;

    @ApiModelProperty(value = "预测第九日库存")
    private BigDecimal forecastNinedayInventory;

    @ApiModelProperty(value = "预测第十日库存")
    private BigDecimal forecastTendayInventory;

    @ApiModelProperty(value = "预测第十一日库存")
    private BigDecimal forecastElevendayInventory;

    @ApiModelProperty(value = "预测第十二日库存")
    private BigDecimal forecastTwelvedayInventory;

    @ApiModelProperty(value = "预测第十三日库存")
    private BigDecimal forecastThridteendayInventory;

    @ApiModelProperty(value = "预测第十四日库存")
    private BigDecimal forecastFourteendayInventory;

    @ApiModelProperty(value = "预测第十五日库存")
    private BigDecimal forecastFifteendayInventory;

    @ApiModelProperty(value = "预测第十六日库存")
    private BigDecimal forecastSixteendayInventory;

    @ApiModelProperty(value = "预测第十七日库存")
    private BigDecimal forecastSeventeendayInventory;

    @ApiModelProperty(value = "预测第十八日库存")
    private BigDecimal forecastEighteendayInventory;

    @ApiModelProperty(value = "预测第十九日库存")
    private BigDecimal forecastNineteendayInventory;

    @ApiModelProperty(value = "预测第二十日库存")
    private BigDecimal forecastTwentydayInventory;

    @ApiModelProperty(value = "预测第二十一日库存")
    private BigDecimal forecastTwentyOnedayInventory;

    @ApiModelProperty(value = "预测第二十二日库存")
    private BigDecimal forecastTwentyTwodayInventory;

    @ApiModelProperty(value = "预测第二十三日库存")
    private BigDecimal forecastTwentyThreedayInventory;

    @ApiModelProperty(value = "预测第二十四日库存")
    private BigDecimal forecastTwentyFourthdayInventory;

    @ApiModelProperty(value = "预测第二十五日库存")
    private BigDecimal forecastTwentyFivedayInventory;

    @ApiModelProperty(value = "预测第二十六日库存")
    private BigDecimal forecastTwentySixdayInventory;

    @ApiModelProperty(value = "预测第二十七日库存")
    private BigDecimal forecastTwentySevenedayInventory;

    @ApiModelProperty(value = "预测第二十八日库存")
    private BigDecimal forecastTwentyEightdayInventory;

    @ApiModelProperty(value = "预测第二十九日库存")
    private BigDecimal forecastTwentyNinedayInventory;

    @ApiModelProperty(value = "预测第三十日库存")
    private BigDecimal forecastThirtydayInventory;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "SKU标题")
    private String skuTitle;

    @ApiModelProperty(value = "详细数据")
    private String details;


}
