create definer = root@`%` view view_sku_sales as
select sum((`bailun_datacenter`.`dc_base_oms_sku`.`bailun_sku_quantity_ordered` *
            `bailun_datacenter`.`dc_base_oms_sku`.`amount_sales`))              AS `amount_sales`,
       sum(`bailun_datacenter`.`dc_base_oms_sku`.`bailun_sku_quantity_ordered`) AS `sales_count`,
       `bailun_datacenter`.`dc_base_oms_sku`.`bailun_sku`                       AS `bailun_sku`,
       `bailun_datacenter`.`dc_base_oms_sku`.`warehouse_code`                   AS `warehouse_code`,
       `bailun_datacenter`.`dc_base_oms_sku`.`platform_type`                    AS `platform_type`
from `bailun_datacenter`.`dc_base_oms_sku`
where ((`bailun_datacenter`.`dc_base_oms_sku`.`bailun_order_status` <> 'Canceled') and
       (`bailun_datacenter`.`dc_base_oms_sku`.`has_delete` = 0) and
       (`bailun_datacenter`.`dc_base_oms_sku`.`paid_time` >= (curdate() - interval 1 day)) and
       (`bailun_datacenter`.`dc_base_oms_sku`.`paid_time` < (curdate() - interval 0 day)))
group by `bailun_datacenter`.`dc_base_oms_sku`.`bailun_sku`, `bailun_datacenter`.`dc_base_oms_sku`.`warehouse_code`,
         `bailun_datacenter`.`dc_base_oms_sku`.`platform_type`;

-- comment on column view_sku_sales.bailun_sku not supported: 百伦SKU

-- comment on column view_sku_sales.warehouse_code not supported: 百伦SKU仓库编码,不是FBA订单照旧,FBA订单放最高优先级共享仓库

-- comment on column view_sku_sales.platform_type not supported: 平台类型

