create definer = root@`%` view view_goods_moq as
(
select `t6`.`product_inner_code`                     AS `product_inner_code`,
       `t6`.`suppliers_id`                           AS `suppliers_id`,
       `t1`.`warehouse_code`                         AS `warehouse_code`,
       sum(greatest(`t1`.`quantity_init_advise`, 0)) AS `sum_quantity_init_advise`,
       max(`t6`.`moq`)                               AS `max_moq`,
       sum(`t1`.`history_fourteenday_sales`)         AS `sum_history_fourteenday_sales`,
       count(1)                                      AS `sku_count`,
       group_concat(`t6`.`bailun_sku` separator ',') AS `sku_codes`
from (((`bailun_datacenter`.`dc_auto_turnover` `t1` left join `bailun_datacenter`.`dc_auto_config_sku_warehouse` `t5` on ((
        (`t1`.`bailun_sku` = `t5`.`bailun_sku`) and
        (`t1`.`warehouse_code` = `t5`.`warehouse_code`)))) left join `bailun_datacenter`.`dc_base_sku` `t6` on ((`t1`.`bailun_sku` = `t6`.`bailun_sku`)))
         left join `bailun_datacenter`.`dc_auto_jit_tag` `t8` on ((`t1`.`tag_id` = `t8`.`id`)))
where (((`t1`.`history_fourteenday_sales` > 0) or (`t1`.`quantity_out_stock` > 0)) and
       ((`t5`.`status` = 0) or isnull(`t5`.`status`)) and (`t6`.`status` = 2) and
       ((`t6`.`buyer_name` not in ('赵美聪', '张莹霞', '张莹霞1')) or (`t1`.`warehouse_code` not in ('GZBLWH', 'GZBLYS')) or
        ((`t1`.`tag_id` > 0) and (`t8`.`is_eliminate` = 0))))
group by `t6`.`product_inner_code`, `t6`.`suppliers_id`, `t1`.`warehouse_code`);

-- comment on column view_goods_moq.product_inner_code not supported: 内部商品编码

-- comment on column view_goods_moq.suppliers_id not supported: 供应商Id

-- comment on column view_goods_moq.warehouse_code not supported: 仓库编码

-- comment on column view_goods_moq.max_moq not supported: 最小订单数-供应商

