create definer = root@`%` view view_estimated_arrival_time as
(
select `t7_1`.`warehouse_code`                                                                                       AS `warehouse_code`,
       `t7_1`.`bailun_sku`                                                                                           AS `bailun_sku`,
       (to_days(`t7_1`.`estimated_arrival_time`) - (case
                                                        when (`t7_1`.`pay_type` = 1) then to_days(`t7_1`.`pay_time`)
                                                        else to_days(`t7_1`.`confirm_time`) end))                    AS `new_supplier_delivery`
from `bailun_datacenter`.`dc_base_purchase` `t7_1`
where concat(`t7_1`.`bailun_sku`, `t7_1`.`purchase_id`) in
      (select max(concat(`t7_2`.`bailun_sku`, `t7_2`.`purchase_id`))
       from `bailun_datacenter`.`dc_base_purchase` `t7_2`
       where ((`t7_2`.`estimated_arrival_time` is not null) and (`t7_2`.`buy_status` = 4))
       group by `t7_2`.`warehouse_code`, `t7_2`.`bailun_sku`));

-- comment on column view_estimated_arrival_time.warehouse_code not supported: 仓库编码

