create definer = root@`%` view view_buy_ontheway_detail as
select `t1`.`bailun_sku`                                                         AS `bailun_sku`,
       (case
            when (`t2`.`warehouse_code` in ('QYBLZZ', 'GZBLWH')) then 'QYBLZZ-GZBLWH'
            else `t2`.`warehouse_code` end)                                      AS `warehouse_code`,
       group_concat(
               concat('【', `t2`.`purchase_id`, ' | ', `t1`.`quantity_purchase`, ' | ', `t1`.`quantity_inbound`, ' | ',
                      convert(ifnull(`t2`.`estimated_arrival_time`, '1990-01-01') using utf8), ' | ',
                      ifnull(`t2`.`supplier_name`, ''), ' | ', ifnull(`t1`.`alibaba_order_id`, ''), ' | ',
                      ifnull(`t1`.`logistics_order_id`, ''), '】') separator ',') AS `buy_ontheway_detail`
from (`bailun_datacenter`.`dc_base_purchase_details` `t1`
         left join `bailun_datacenter`.`dc_base_purchase` `t2`
                   on (((`t1`.`bailun_sku` = `t2`.`bailun_sku`) and (`t1`.`purchase_id` = `t2`.`purchase_id`))))
where ((`t1`.`status` not in (-(1), 4)) and (`t2`.`buy_status` not in (-(1), 4)) and
       (`t1`.`quantity_not_inbound` > 0) and (`t2`.`has_delete` = 0))
group by `t1`.`bailun_sku`, (case
                                 when (`t2`.`warehouse_code` in ('QYBLZZ', 'GZBLWH')) then 'QYBLZZ-GZBLWH'
                                 else `t2`.`warehouse_code` end);

