package com.bailuntec.job.service;

import com.bailuntec.domain.DcAutoUprushConfig;
import com.bailuntec.domain.DcBaseOmsSku30;
import com.bailuntec.domain.DcBaseStock;
import com.bailuntec.domain.DcBaseWarehouse;
import com.bailuntec.infrastructure.mapper.DcAutoSalesMapper;
import com.bailuntec.infrastructure.mapper.DcAutoUprushConfigMapper;
import com.bailuntec.infrastructure.mapper.DcBaseOmsSku30Mapper;
import com.bailuntec.infrastructure.mapper.DcBaseWarehouseMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/25 2:53 下午
 */
@Service
public class ShowAutoTurnover {

    @Resource
    DcBaseWarehouseMapper dcBaseWarehouseMapper;
    @Resource
    DcAutoSalesMapper dcAutoSalesMapper;
    @Resource
    DcAutoUprushConfigMapper dcAutoUprushConfigMapper;
    @Resource
    DcBaseOmsSku30Mapper dcBaseOmsSku30Mapper;


    public static ThreadLocal<ShowAutoTurnoverParam> threadLocal = new ThreadLocal<>();

    public void syncAutoTurnover(DcBaseStock dcBaseStock) {

        LambdaQueryWrapper<DcBaseOmsSku30> wrapper = new LambdaQueryWrapper<>();
        wrapper.lt(DcBaseOmsSku30::getPaidTime, threadLocal.get().getQueryTime())
                .ne(DcBaseOmsSku30::getBailunOrderStatus, "Canceled")
                .eq(DcBaseOmsSku30::getHasFbaS, 0)
                .eq(DcBaseOmsSku30::getHasDelete, 0)
                .eq(DcBaseOmsSku30::getHasScalp, 0)
                .eq(DcBaseOmsSku30::getHasBuyerRemark, 0)
                .eq(DcBaseOmsSku30::getHasPlatskuRemark, 0)
                .eq(DcBaseOmsSku30::getHasInnersale, 0)
                .eq(DcBaseOmsSku30::getBailunSku, dcBaseStock.getBailunSku())
                .eq(DcBaseOmsSku30::getWarehouseCode, dcBaseStock.getWarehouseCode())
                .ne(DcBaseOmsSku30::getPlatformOrderType, "手工单")
        ;

    }

    BigDecimal uprushSales() {
        String bailunSku = threadLocal.get().getBailunSku();
        String warehouseCode = threadLocal.get().getWarehouseCode();

        DcBaseWarehouse dcBaseWarehouse = dcBaseWarehouseMapper.selectByWarehouseCode(warehouseCode);
        // 获取7、14日均销量
        BigDecimal agvSales = dcAutoSalesMapper.getSalesAvg(threadLocal.get().getQueryTime(), bailunSku, warehouseCode);

        //如果仓库不为空
        if (dcBaseWarehouse != null) {
            //销量突增检测
            DcAutoUprushConfig dcAutoUprushConfig = dcAutoUprushConfigMapper.selectByWarehouse(dcBaseWarehouse);
            if (dcAutoUprushConfig != null && agvSales != null) {
                // 突增销量 = (7+14日均销量)/2 * 突增率
                BigDecimal incrementalRatio = BigDecimal.ONE.add(dcAutoUprushConfig.getPercentage());
                return agvSales.multiply(incrementalRatio).setScale(0, RoundingMode.UP);
            }
        }
        return BigDecimal.ZERO;
    }
}
