package com.bailuntec.job;

import com.bailuntec.application.IDcBaseFinanceEbayService;
import com.bailuntec.domain.DcBaseFinanceEbay;
import lombok.extern.slf4j.Slf4j;
import org.springframework.batch.item.ItemWriter;
import org.springframework.lang.NonNull;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/19 1:21 下午
 */
@Slf4j
public class EbayFinanceWriter implements ItemWriter<DcBaseFinanceEbay> {

    final IDcBaseFinanceEbayService dcBaseFinanceEbayService;

    public EbayFinanceWriter(IDcBaseFinanceEbayService dcBaseFinanceEbayService) {
        this.dcBaseFinanceEbayService = dcBaseFinanceEbayService;
    }

    @Override
    public void write(@NonNull List<? extends DcBaseFinanceEbay> items) {
        log.info("批量写入DcBaseFinanceEbay");
        List<DcBaseFinanceEbay> list = items.stream()
                .map(var -> (DcBaseFinanceEbay)var)
                .collect(
                Collectors.collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(DcBaseFinanceEbay::getRefNumber)))
                        , ArrayList::new)
        );
        dcBaseFinanceEbayService.BatchInsertIgnoreExist(list);
    }
}
