package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 基础SKU信息表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseSku对象", description="基础SKU信息表")
public class DcBaseSku implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "SKU主图")
    private String skuImage;

    @ApiModelProperty(value = "分类编码")
    private Integer categoryId;

    @ApiModelProperty(value = "分类名称")
    private String categoryName;

    @ApiModelProperty(value = "采购单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "销售员id")
    private Integer sellerId;

    @ApiModelProperty(value = "销售员名称")
    private String sellerName;

    @ApiModelProperty(value = "长度 - 包装")
    private BigDecimal length;

    @ApiModelProperty(value = "宽度 - 包装")
    private BigDecimal width;

    @ApiModelProperty(value = "高度 - 包装")
    private BigDecimal height;

    @ApiModelProperty(value = "重量 = 包装重量 + 产品重量")
    private BigDecimal weight;

    @ApiModelProperty(value = "最小订单数-供应商")
    private Integer moq;

    @ApiModelProperty(value = "SKU中文标题")
    private String skuTitleCn;

    @ApiModelProperty(value = "SKU英文标题")
    private String skuTitleEn;

    @ApiModelProperty(value = "SKU系统创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "SKU系统更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "供应商Id")
    private Integer suppliersId;

    @ApiModelProperty(value = "供应商名称")
    private String suppliersName;

    @ApiModelProperty(value = "供应商交期")
    private Integer supplierDelivery;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "采购员名称")
    private String buyerName;

    @ApiModelProperty(value = "采购员Id")
    private Integer buyerId;

    @ApiModelProperty(value = "内部最小订单数")
    private Integer internalMoq;

    @ApiModelProperty(value = "开发员Id")
    private Integer bussinessId;

    @ApiModelProperty(value = "开发员名称")
    private String bussinessName;

    @ApiModelProperty(value = "商品状态 1停售，2在售")
    private Integer status;

    @ApiModelProperty(value = "1成品，2半成品，3耗材，4固定资产，5组合SKU")
    private Integer type;

    @ApiModelProperty(value = "商品编码")
    private String productCode;

    @ApiModelProperty(value = "内部产品编码")
    private String bailunInnerSku;

    @ApiModelProperty(value = "内部商品编码")
    private String productInnerCode;

    @ApiModelProperty(value = "SKUMS的主键Id")
    private Integer skumsId;

    @ApiModelProperty(value = "供应商商品链接")
    private String suppliersLink;

    @ApiModelProperty(value = "百伦分类id")
    private Integer bailunCategoryId;

    @ApiModelProperty(value = "百伦分类名称")
    private String bailunCategoryName;

    @ApiModelProperty(value = "颜色")
    private String color;

    @ApiModelProperty(value = "规格")
    private String specifications;

    @ApiModelProperty(value = "创建人")
    private String createName;

    @ApiModelProperty(value = "更新人")
    private String updateName;

    @ApiModelProperty(value = "虚拟采购价")
    private BigDecimal virtualPrice;

    @ApiModelProperty(value = "尺码图片")
    private String sizeImage;

    @ApiModelProperty(value = "销售价格")
    private BigDecimal salesPrice;

    @ApiModelProperty(value = "是否启用")
    private Integer enable;

    @ApiModelProperty(value = "质检工时")
    private BigDecimal inspectionHours;

    @ApiModelProperty(value = "找货员")
    private String bargainer;

    @ApiModelProperty(value = "海关编码")
    private String customsCode;

    @ApiModelProperty(value = "英文申报名")
    private String declareTitleEn;

    @ApiModelProperty(value = "中文申报名")
    private String declareTitleCn;

    @ApiModelProperty(value = "中文配货名")
    private String pickTitleCn;

    @ApiModelProperty(value = "英文配货名")
    private String pickTitleEn;

    @ApiModelProperty(value = "产品性质")
    private String productNature;

    @ApiModelProperty(value = "充电器规格")
    private String chargerSpecifications;

    @ApiModelProperty(value = "包装价格")
    private BigDecimal packingPrice;

    @ApiModelProperty(value = "包装名称")
    private String packingName;

    @ApiModelProperty(value = "包装尺寸")
    private String packingSize;

    @ApiModelProperty(value = "产品尺寸")
    private String productSize;

    @ApiModelProperty(value = "包装重量")
    private BigDecimal packingWeight;

    @ApiModelProperty(value = "单位")
    private String unit;

    @ApiModelProperty(value = "推送产品库状态,1推送")
    private Integer pushStatus;

    @ApiModelProperty(value = "调拨交期")
    private Integer transferDelivery;

    @ApiModelProperty(value = "开发来源:1精准开发，2线下（其他）3线下美容  6普货供应商推荐   7服装产品中心   11 无库供应商推荐")
    private Integer source;

    @ApiModelProperty(value = "推送时间")
    private LocalDateTime pushTime;

    @ApiModelProperty(value = "是否删除")
    private Boolean hasDelete;

    @ApiModelProperty(value = "开发时间")
    private LocalDateTime developTime;

    @ApiModelProperty(value = "公司Id, 默认0是无意义的")
    private Integer companyId;

    @ApiModelProperty(value = "简单分类Id")
    private Integer categorySimpleId;

    @ApiModelProperty(value = "简单分类名称")
    private String categorySimpleName;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "类型编码")
    private Integer productType;

    @ApiModelProperty(value = "类型名称")
    private String productTypeDesc;

    @ApiModelProperty(value = "dc_base_sku_tag.tag_values_name 逗号隔开")
    private String tags;


}
