package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 物流单费用
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseLogistics对象", description="物流单费用")
public class DcBaseLogistics implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "wms唯一键")
    private Integer wmsId;

    @ApiModelProperty(value = "供应商Code")
    private String companyCode;

    @ApiModelProperty(value = "供应商名称")
    private String companyName;

    @ApiModelProperty(value = "单号")
    private String billCode;

    @ApiModelProperty(value = "跟踪号")
    private String trackingNo;

    @ApiModelProperty(value = "商家计费重量")
    private BigDecimal merchantOutputWeightKg;

    @ApiModelProperty(value = "计费费用")
    private BigDecimal merchantShipmentCostCny;

    @ApiModelProperty(value = "商家账单时间")
    private LocalDateTime merchantReconciliationTime;

    @ApiModelProperty(value = "费用类型")
    private String reconciliationType;

    private String infoId;

    @ApiModelProperty(value = "物流商计费重量")
    private BigDecimal outputWeightKg;

    @ApiModelProperty(value = "百伦计费金额(CNY)")
    private BigDecimal bailunShipmentCostCny;

    @ApiModelProperty(value = "发货时间")
    private LocalDateTime shipmentTime;

    @ApiModelProperty(value = "是否有差异")
    private String diffStateType;

    @ApiModelProperty(value = "商家计费重量")
    private BigDecimal merchantOutputWeightKgOriginal;

    @ApiModelProperty(value = "计费费用")
    private BigDecimal merchantShipmentCostSnyOriginal;

    @ApiModelProperty(value = "差异金额")
    private BigDecimal costDiffDecimal;

    @ApiModelProperty(value = "差异重量")
    private BigDecimal weightDiffDecimal;

    @ApiModelProperty(value = "渠道名称")
    private String lineName;

    @ApiModelProperty(value = "费用单号")
    private String feeCode;

    @ApiModelProperty(value = "备注说明")
    private String remark;

    @ApiModelProperty(value = "生成状态")
    private String generateBillStatus;

    @ApiModelProperty(value = "费用类型")
    private String feeProductType;

    @ApiModelProperty(value = "最后修改时间")
    private LocalDateTime lastModificationTime;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreateTime;

    @ApiModelProperty(value = "数据中心最后更改时间")
    private LocalDateTime gmtModifyTime;


}
