package com.bailuntec.task.listener;

import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.bailuntec.task.config.JobProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 5:12 下午
 */
@Slf4j
@Component
public class TaskListener implements JobExecutionListener {
    @Resource
    JobProperty jobProperty;
    @Resource
    DcJobConfigMapper dcJobConfigMapper;

    @Override
    public void afterJob(@NonNull JobExecution jobExecution) {

        DcJobConfig dcJobConfig = jobProperty.getDcJobConfig();

        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            log.info("!!! JOB FINISHED! Time to verify the results");
        }

        if (jobExecution.getStatus() == BatchStatus.FAILED) {
            //todo 任务失败提醒推送
            log.error("!!! JOB FAILED");
        }

        dcJobConfigMapper.updateById(dcJobConfig.refresh());

    }

    @Override
    public void beforeJob(@NonNull JobExecution jobExecution) {
        log.info("Before..");
    }
}
