package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-10-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcJobConfig对象", description = "")
public class DcJobConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "任务名")
    private String jobName;

    private Integer pageNum;
    private Integer pageSize;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "运行开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "运行结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    public String getStartTimeStr() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(startTime.minusMinutes(3));
    }

    public String getEndTimeStr() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(endTime);
    }

    private LocalDateTime getNextEndTime() {
        return endTime.plusDays(1).isAfter(LocalDateTime.now())
                ? LocalDateTime.now()
                : endTime.plusDays(1);
    }

    public DcJobConfig refresh() {
        this.startTime = endTime;
        this.endTime = this.getNextEndTime();
        this.gmtModified = LocalDateTime.now();
        this.pageNum = 1;
        return this;
    }
}
