package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仓库信息表
 * </p>
 *
 * @author robbendev
 * @since 2020-11-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseWarehouse对象", description="仓库信息表")
public class DcBaseWarehouse implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "外部仓库 名称")
    private String warehouseExtendName;

    @ApiModelProperty(value = "功能")
    private String functions;

    @ApiModelProperty(value = "旧仓库编码")
    private String warehouseOldCode;

    @ApiModelProperty(value = "仓库系统")
    private String systemFlag;

    @ApiModelProperty(value = "百伦账号Id")
    private Integer bailunAccountId;

    @ApiModelProperty(value = "百伦账号")
    private String bailunAccount;

    @ApiModelProperty(value = "环球仓库类型")
    private String hqType;

    private Integer typeId;

    private String typeName;

    private Integer areaId;

    private String areaName;

    @ApiModelProperty(value = "仓库Id")
    private Integer warehouseId;

    @ApiModelProperty(value = "仓库属性：（自发货仓，第三方仓）")
    private String warehouseTypeEx;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;


}
