# 新数据中心java同步服务
新数据中心同步服务

## 一、如何使用

### 1.1 项目架构
k8s集群: bailun/data-center-job  
datacenter-task: spring-cloud-data-flow + spring batch  
datacenter-job:  spring schedule  
datacenter-domain: 领域模块  


### 1.2 主要三方库
- springboot 
- mybatis
- mybatis plus 

### 1.3 部署环境
- 子账号k8s集群 bailun/data-center-job deployment名称同镜像名称
- 镜像名称见pom.xml 
- scdf地址http://dataflow.bailuntec.com/dashboard/index.html 只迁移了两个 使用见springcloud data flow官方文档。
- scdf 部署在k8s集群 命名空间 /default/service/scdf-server, /default/ingress/datacenter-scdf,/default/secret/scdf-sa-token-qgtsp
, /default/configMap/scdf-server.. ,
```xml
<imageName>ccr.ccs.tencentyun.com/blt.data.job/ebay-report-produce:latest</imageName>
```
 
## 二、项目结构
```
├── data-api   //外部api
├── data-base
│   ├── base-sync-amazon-ad         //同步亚马逊广告费用
│   ├── base-sync-cashier           //同步财务信息
│   ├── base-sync-company           //同步公司和账户信息
│   ├── base-sync-cost-first        //同步物流头程费用
│   ├── base-sync-crm-refund        //同步CRM系统退款
│   ├── base-sync-finance-ebay      //同步EBAY费用信息
│   ├── base-sync-finance-fee       //同步费用系统信息 
│   ├── base-sync-finance-wish      //同步WISH费用信息
│   ├── base-sync-oms-order         //同步OMS系统订单
│   ├── base-sync-paypal            //同步Paypal流水
│   ├── base-sync-purchase          //同步采购系统流水
│   ├── base-sync-purchase-details  //同步采购系统详情
│   ├── base-sync-semi-order        //同步半成品信息
│   ├── base-sync-shopify           //同步SHOPIFY数据
│   ├── base-sync-sku               //同步SKUMS
│   ├── base-sync-stock-wms         //同步WMS系统库存
│   ├── base-sync-transfer          //同步调拨流水
│   └── base-sync-warehouse         //同步仓库信息
├── data-common  //实体 方法
├── data-finance
│   ├── finance-accounting-entry
│   └── finance-balance-sheet
├── data-mid                        //mid-中间数据处理
│   ├── mid-auto-turnover-prepare   //（过期）
│   ├── mid-calculate-cost-first    //计算头程费
│   ├── mid-calculate-item          //
│   ├── mid-calculate-sales         //计算销量
│   ├── mid-calculate-transit       //计算在途,缺货等数据
│   ├── mid-daily-stock             //计算每日库存
│   ├── mid-duration-stock          //计算库龄
│   ├── mid-ebay-uk-report          //ebay-uk发货分析报表
│   └── mid-fba-fee-avg             //计算FBA平均费用
├── data-show                       //show-数据价值展现
│   └── show-auto-turnover          //计算周转

```
## 三、如何开发
略
