package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceEbayItem对象", description="")
public class DcBaseFinanceEbayItem implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "ebay表主键值")
    private Integer ebayId;

    @ApiModelProperty(value = "费用类型")
    private String accountEntryType;

    @ApiModelProperty(value = "费用产生时间,以GMT格式指示条目过帐到帐户的日期和时间")
    private LocalDateTime gmtDate;

    @ApiModelProperty(value = "费用产生时间,以GMT+8格式指示条目过帐到帐户的日期和时间")
    private LocalDateTime bjDate;

    @ApiModelProperty(value = "ebay评估的总费用,包括净费用和增值税")
    private BigDecimal grossAmount;

    @ApiModelProperty(value = "sku分摊费用")
    private BigDecimal skuAmount;

    @ApiModelProperty(value = "sku数量")
    private Integer skuCount;

    @ApiModelProperty(value = "sku分摊比例")
    private BigDecimal skuRatio;

    @ApiModelProperty(value = "item_id")
    private String itemId;

    @ApiModelProperty(value = "百伦sku")
    private String bailunSku;

    @ApiModelProperty(value = "帐号id")
    private Integer accountId;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "转人民币汇率,根据bj_date取值")
    private BigDecimal exchangeRate;

    private String orderLineId;

    private Integer companyId;

    @ApiModelProperty(value = "转美元汇率")
    private BigDecimal exchangeRateUsd;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime bjCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime bjModified;


}
