package com.bailuntec.domain;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceCashier对象", description="")
public class DcBaseFinanceCashier implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "出纳编号")
    private String code;

    @ApiModelProperty(value = "申请单编号")
    private String applyId;

    @ApiModelProperty(value = "申请标题")
    private String detailName;

    @ApiModelProperty(value = "出纳单类型:1#付款;2#收款;3#无需付款;")
    private Integer cashierType;

    @ApiModelProperty(value = "费用大类")
    private String typeName;

    @ApiModelProperty(value = "公司主体值")
    private Integer companymainValueFrom;

    @ApiModelProperty(value = "公司主体名称")
    private String companymainNameFrom;

    @ApiModelProperty(value = "交易币种编号")
    private String unitCode;

    @ApiModelProperty(value = "交易币种名称")
    private String unitName;

    @ApiModelProperty(value = "交易总金额")
    private BigDecimal paymoney;

    @ApiModelProperty(value = "交易总金额-人民币")
    private BigDecimal paymoneyRmb;

    private Integer payday;

    private LocalDateTime expectPaytime;

    @ApiModelProperty(value = "交易对象类型:1#供应商;2#费用用户;")
    private Integer tradebBjecttype;

    @ApiModelProperty(value = "交易对象id")
    private Integer tradebBjectid;

    private String tradebBjectname;

    @ApiModelProperty(value = "交易-银行账户ID")
    private Integer bankaccountidTo;

    @ApiModelProperty(value = "交易-银行账号")
    private String bankcardTo;

    @ApiModelProperty(value = "交易-银行名称")
    private String banknameTo;

    @ApiModelProperty(value = "交易持卡人")
    private String bankcarduserTo;

    @ApiModelProperty(value = "申请备注")
    private String applyremark;

    @ApiModelProperty(value = "出纳回调状态:0#未回调;1#回调成功;2#回调失败;")
    private Integer cashierCallbackstatus;

    @ApiModelProperty(value = "申请来源编号")
    private String sourcecode;

    @ApiModelProperty(value = "申请来源名称")
    private String sourcename;

    @ApiModelProperty(value = "出纳状态:0#待收付;1#已收付;2#已驳回;3#无需付款;4#申请代付未付款;5#1688自动付款失败;")
    private Integer cashierStatus;

    @ApiModelProperty(value = "付款方式:0#手工付款;1#1688自动付款;")
    private Integer payType;

    @ApiModelProperty(value = " 出纳操作人")
    private Integer cashierUserid;

    @ApiModelProperty(value = "出纳操作人名称")
    private String cashierUsername;

    private LocalDateTime cashierTime;

    @ApiModelProperty(value = "出纳操作备注")
    private String cashierRemark;

    @ApiModelProperty(value = "出纳账户id")
    private Integer cashierBankaccountid;

    @ApiModelProperty(value = "出纳账户名称")
    private String cashierBankname;

    @ApiModelProperty(value = "出纳账户卡号")
    private String cashierBankcard;

    @ApiModelProperty(value = "出纳账户持卡人")
    private String cashierBankcardname;

    @ApiModelProperty(value = "出纳币种编号")
    private String cashierUnitcode;

    @ApiModelProperty(value = "出纳币种名称")
    private String cashierUnitname;

    @ApiModelProperty(value = "出纳汇率")
    private BigDecimal cashierRate;

    @ApiModelProperty(value = "出纳总金额")
    private BigDecimal cashierPaymoney;

    @ApiModelProperty(value = "出纳人民币总金额")
    private BigDecimal cashierPaymoneyrmb;

    @ApiModelProperty(value = "是否有问题:0#正常;1#问题单")
    private Boolean isquestion;

    @ApiModelProperty(value = "问题单备注")
    private String questionRemark;

    @ApiModelProperty(value = "1688/淘宝订单号")
    private String taobaoOrderNo;

    @ApiModelProperty(value = "其他订单流水号")
    private String otherorderCode;

    @ApiModelProperty(value = " 创建人id")
    private Integer createUserid;

    @ApiModelProperty(value = "创建人名称")
    private String createUsername;

    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人id")
    private Integer modifyUserid;

    @ApiModelProperty(value = "更新人名称")
    private String modifyUsername;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime modifyTime;


}
