package com.bailuntec.job;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/20 6:22 下午
 */
@Configuration
public class DataSourceConfig {

    @Bean
    @ConfigurationProperties(prefix = "spring.dataflow-datasource")
    public DataSourceProperties dataflowDataSourceProperties() {
        return new DataSourceProperties();
    }


    @Bean
    public DataSource dataflowDataSource(@Qualifier("dataflowDataSourceProperties") DataSourceProperties dataSourceProperties) {
        return DataSourceBuilder.create()
                .driverClassName(dataSourceProperties.getDriverClassName())
                .url(dataSourceProperties.getUrl())
                .username(dataSourceProperties.getUsername())
                .password(dataSourceProperties.getPassword())
                .build();
    }


    @Primary
    @Bean
    @ConfigurationProperties(prefix = "spring.datasource-biz")
    public DataSourceProperties bizDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Primary
    @Bean
    public DataSource bizDataSource(@Qualifier("bizDataSourceProperties") DataSourceProperties dataSourceProperties) {
        return DataSourceBuilder
                .create()
                .driverClassName(dataSourceProperties.getDriverClassName())
                .url(dataSourceProperties.getUrl())
                .username(dataSourceProperties.getUsername())
                .password(dataSourceProperties.getPassword())
                .build();
    }

}
