package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcBaseCost;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.time.LocalDate;

/**
 * <p>
 * 费用单基础表（对应费用系统） Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcBaseCostMapper extends BaseMapper<DcBaseCost> {

    /**
     * 根据费用单号查询
     *
     * @param costNo 费用单号查询
     * @return 费用单
     */
    DcBaseCost selectByCostNo(String costNo);


    /**
     * 删除要过滤的公司主体数据
     *
     * @param date data
     */
    void deleteUnusedCost(LocalDate date);
}
