package com.bailuntec.application.impl;

import com.bailuntec.application.IDcBalanceSheetNewModifyService;
import com.bailuntec.domain.DcBalanceSheetNewModify;
import com.bailuntec.infrastructure.mapper.DcBalanceSheetNewModifyMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 * 资产负债表,RMB 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-02
 */
@Service
public class DcBalanceSheetNewModifyServiceImpl extends ServiceImpl<DcBalanceSheetNewModifyMapper, DcBalanceSheetNewModify> implements IDcBalanceSheetNewModifyService {


    @Override
    public void record(DcBalanceSheetNewModify dcBalanceSheetNewModify) {
        this.saveOrUpdate(dcBalanceSheetNewModify,
                new LambdaQueryWrapper<DcBalanceSheetNewModify>()
                        .eq(DcBalanceSheetNewModify::getStatisticalTime, dcBalanceSheetNewModify.getStatisticalTime()));
    }
}
