package com.bailuntec.job.service;

import com.alibaba.fastjson.JSON;
import com.bailuntec.api.bailuntec.cw.CwApi;
import com.bailuntec.api.bailuntec.cw.response.BankAccountBalanceDTO;
import com.bailuntec.api.bailuntec.cw.response.BorrowBalanceDTO;
import com.bailuntec.api.bailuntec.cw.response.PayPalBalanceDTO;
import com.bailuntec.api.bailuntec.cw.response.WithdrawOnWayDTO;
import com.bailuntec.api.bailuntec.mj.MjzzApi;
import com.bailuntec.api.bailuntec.mj.resp.MjzzPage;
import com.bailuntec.api.bailuntec.mj.resp.MjzzResult;
import com.bailuntec.api.bailuntec.mj.resp.StockLogResp;
import com.bailuntec.api.bailuntec.mjcg.MjcgApi;
import com.bailuntec.api.bailuntec.mjcg.MjgysApi;
import com.bailuntec.api.bailuntec.mjcg.resp.MjcgResult;
import com.bailuntec.api.bailuntec.mjcg.resp.MjgysResult;
import com.bailuntec.api.bailuntec.mjcg.resp.SemiPurchaseDetailPageInfoDTO;
import com.bailuntec.api.bailuntec.mjcg.resp.SupofferLogResp;
import com.bailuntec.api.bailuntec.purchase.PurchaseApi;
import com.bailuntec.api.bailuntec.purchase.resp.LogisticsSupplierTransactionDTO;
import com.bailuntec.api.bailuntec.purchase.resp.PurchaseResult;
import com.bailuntec.api.bailuntec.purchase.resp.SupplierTransactionDTO;
import com.bailuntec.application.*;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.cost.api.BuyApi;
import com.bailuntec.cost.api.CostApi;
import com.bailuntec.cost.api.domain.BuyDomain;
import com.bailuntec.domain.*;
import com.bailuntec.infrastructure.mapper.*;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class BalanceSheetService {

    private static final String financeSyncBankAccount = "finance-sync-bank-account";
    private static final String financeSyncWithdrawOnWaySummary = "finance-sync-withdraw-on-way-summary";
    private static final String financeSyncShortBorrowBalance = "finance-sync-short-borrow-balance";
    private static final String financeSyncCost = "finance-sync-cost";
    private static final String financeSyncBuy = "finance-sync-buy";
    private static final String financeGenerateBalanceSheet = "finance-generate-balance-sheet";
    private static final String financeGenerateBalanceSheetNewResult = "finance-generate-balance-sheet-new-result";
    private static final String financeSyncPayPal = "finance-sync-pay-pal";
    private static final String baseSyncSemiStock = "base_sync_semi_stock";
    private static final String baseSyncSemiTransfer = "base_sync_semi_transfer";

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    CwApi cwApi;
    @Resource
    IDcBankAccountBalanceService dcBankAccountBalanceService;
    @Resource
    IDcBankAccountBalanceNewService dcBankAccountBalanceNewService;
    @Resource
    DcBankAccountBalanceMapper dcBankAccountBalanceMapper;
    @Resource
    IDcWithdrawOnWayService dcWithdrawOnWayService;
    @Resource
    DcWithdrawOnWayMapper dcWithdrawOnWayMapper;

    /**
     * 同步银行余额
     */
//    @Transactional(rollbackFor = Exception.class)
    public void syncBankAccount() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeSyncBankAccount);

        LocalDate date = LocalDate.now().minusDays(1);
        //从财务系统查询银行账户余额
        List<BankAccountBalanceDTO> bankAccountBalanceDTOList = cwApi.getBankAccountSummary().getData();

        //先清空
        dcBankAccountBalanceService.remove(new LambdaQueryWrapper<DcBankAccountBalance>()
                .eq(DcBankAccountBalance::getStatisticalTime, date));
        //保存
        List<DcBankAccountBalance> dcBankAccountBalanceList = bankAccountBalanceDTOList.stream()
                .map(bankAccountBalanceDTO -> {
                    DcBankAccountBalance dcBankAccountBalance = new DcBankAccountBalance();
                    BeanUtils.copyProperties(bankAccountBalanceDTO, dcBankAccountBalance);
                    dcBankAccountBalance.setStatisticalTime(date);
                    return dcBankAccountBalance;
                }).collect(Collectors.toList());

        dcBankAccountBalanceService.saveBatch(dcBankAccountBalanceList);

        //新的

        //先清空
        dcBankAccountBalanceNewService.remove(new LambdaQueryWrapper<DcBankAccountBalanceNew>()
                .eq(DcBankAccountBalanceNew::getStatisticalTime, date));
        //保存
        List<DcBankAccountBalanceNew> dcBankAccountBalanceNewList = bankAccountBalanceDTOList.stream()
                .map(bankAccountBalanceDTO -> {
                    DcBankAccountBalanceNew dcBankAccountBalanceNew = new DcBankAccountBalanceNew();
                    BeanUtils.copyProperties(bankAccountBalanceDTO, dcBankAccountBalanceNew);
                    dcBankAccountBalanceNew.setStatisticalTime(date);
                    return dcBankAccountBalanceNew;
                }).collect(Collectors.toList());

        dcBankAccountBalanceNewService.saveBatch(dcBankAccountBalanceNewList);

        // 删除需要过滤的数据
        dcBankAccountBalanceMapper.deleteUnusedData(date);
        dcBankAccountBalanceMapper.deleteUnusedData1(date);
        dcBankAccountBalanceMapper.deleteUnusedData2(date);

        //更新任务时间
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    /**
     * 同步提现在途
     * 因为提现在途金额保存的是快照 所以为了保证方法的幂等 如果指定日期存在金额 不会覆盖重跑
     *
     * <p>
     * 这个是通过每天跑然后记录 无法通过重跑恢复
     * </p>
     */
    @Transactional(rollbackFor = Exception.class)
    public void syncWithdrawOnWaySummary() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeSyncWithdrawOnWaySummary);

        List<WithdrawOnWayDTO> withdrawOnWayDTOList = cwApi.getWithdrawOnWaySummary().getData();
        LocalDate date = LocalDate.now().minusDays(1);

        LambdaQueryWrapper<DcWithdrawOnWay> wrapper = new LambdaQueryWrapper<DcWithdrawOnWay>()
                .eq(DcWithdrawOnWay::getStatisticalTime, date);

        //如果指定日期在途金额 快照已经存在 跳过
        if (dcWithdrawOnWayService.count(wrapper) > 0) {
            //dcJobConfigMapper.updateById(dcJobConfig.refresh());
            return;
        }

        //清空
        dcWithdrawOnWayService.remove(new LambdaQueryWrapper<DcWithdrawOnWay>()
                .eq(DcWithdrawOnWay::getStatisticalTime, date));

        //保存
        List<DcWithdrawOnWay> dcWithdrawOnWayList = withdrawOnWayDTOList.stream()
                .map(withdrawOnWayDTO -> {
                    DcWithdrawOnWay dcWithdrawOnWay = new DcWithdrawOnWay();
                    BeanUtils.copyProperties(withdrawOnWayDTO, dcWithdrawOnWay);
                    dcWithdrawOnWay.setStatisticalTime(date);
                    return dcWithdrawOnWay;
                })
                .collect(Collectors.toList());
        dcWithdrawOnWayService.saveBatch(dcWithdrawOnWayList);

        // 更新提现在途公司主体value
        dcWithdrawOnWayMapper.updateWithdrawOnWayCompany();

        //更新任务时间
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Resource
    DcShortTermBorrowMapper dcShortTermBorrowMapper;
    @Resource
    IDcShortTermBorrowService dcShortTermBorrowService;


    /**
     * 同步短期借款余额
     */
    @Transactional(rollbackFor = Exception.class)
    public void syncShortBorrowBalance() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeSyncShortBorrowBalance);
        //任务时间
        LocalDate date = LocalDate.now().minusDays(1);

        List<BorrowBalanceDTO> borrowBalanceDTOList = cwApi.getBorrows().getData();

        //清空
        dcShortTermBorrowMapper.delete(new LambdaQueryWrapper<DcShortTermBorrow>()
                .eq(DcShortTermBorrow::getStatisticalTime, date));

        //新增
        List<DcShortTermBorrow> dcShortTermBorrowList = borrowBalanceDTOList.stream()
                .map(borrowBalanceDTO -> {
                    DcShortTermBorrow dcShortTermBorrow = new DcShortTermBorrow();
                    BeanUtils.copyProperties(borrowBalanceDTO, dcShortTermBorrow);
                    dcShortTermBorrow.setStatisticalTime(date);
                    return dcShortTermBorrow;
                })
                .collect(Collectors.toList());
        dcShortTermBorrowService.saveBatch(dcShortTermBorrowList);

        //更新任务时间
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Resource
    CostApi costApi;
    @Resource
    DcBaseCostMapper dcBaseCostMapper;
    @Resource
    IDcBaseCostService dcBaseCostService;
    @Resource
    DcOtherCostMapper dcOtherCostMapper;

    /**
     * 同步数据中心需要的费用单
     */
    @Transactional(rollbackFor = Exception.class)
    public void syncCost() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeSyncCost);

        LocalDate date = LocalDate.now().minusDays(1);

//        List<CostDto> costDtoList = costApi.balanceSheetCostList(dcJobConfig.getStartTimeStr(), dcJobConfig.getEndTimeStr()).getData();
//        costDtoList.forEach(costDto -> {
//
//            DcBaseCost dcBaseCost = dcBaseCostMapper.selectByCostNo(costDto.getCostNo());
//            if (dcBaseCost == null) {
//                dcBaseCost = new DcBaseCost();
//            }
//            BeanUtils.copyProperties(costDto, dcBaseCost, "id");
//            dcBaseCost.setDay(dcJobConfig.getStartTime().toLocalDate());
//            if (costDto.getCostStatus().equals(4)) {
//                dcBaseCost.setIsWaitPay(0);
//            } else {
//                dcBaseCost.setIsWaitPay(1);
//            }
//            dcBaseCostService.saveOrUpdate(dcBaseCost);
//        });

        // 删除要过滤的公司主体数据
        dcBaseCostMapper.deleteUnusedCost(date);

        // 生成一级明细
        dcOtherCostMapper.clearOneDay(date);
        dcOtherCostMapper.insertOneDayOtherReceive(date);
        dcOtherCostMapper.insertOneDayOtherPay(date);

        //更新任务时间
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Resource
    BuyApi buyApi;
    @Resource
    DcBaseBuyMapper dcBaseBuyMapper;
    @Resource
    IDcBaseBuyService dcBaseBuyService;

    /**
     * 同步费用系统采购单：固定资产
     *
     * @throws ParseException ex
     */
    @Transactional(rollbackFor = Exception.class)
    public void syncBuy() throws ParseException {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeSyncBuy);

        LocalDate date = LocalDate.now().minusDays(1);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        List<BuyDomain> buyList = buyApi.balanceSheetBuyList(date.format(dtf), date.plusDays(1).format(dtf)).getData();
        buyList.forEach(buyDomain -> {

            DcBaseBuy dcBaseBuy = dcBaseBuyMapper.selectByBuyNo(buyDomain.getBuyno());
            if (dcBaseBuy == null) {
                dcBaseBuy = new DcBaseBuy();
            }
            BeanUtils.copyProperties(buyDomain, dcBaseBuy, "id");
            dcBaseBuy.setDay(date);

            dcBaseBuyService.saveOrUpdate(dcBaseBuy);
        });

        // 生成一级明细
        dcFixedAssetsDetailMapper.clearFixedAssetsDetail(date);
        dcFixedAssetsDetailMapper.insertFixedAssetsDetail(date);

        //更新任务时间
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }


    @Resource
    IDcPlatformBalanceService dcPlatformBalanceService;

//    @Transactional(rollbackFor = Exception.class)
//    public void syncSemiInventoryBalance() {
//        boolean isOk = true;
//        String param = "?btime=" + DateTimeUtil.dateToString(date, DateTimeUtil.DATE_FORMAT) + "&etime=" + DateTimeUtil.dateToString(datePlusOne, DateTimeUtil.DATE_FORMAT);
//
//        try {
//            SemiResultDTO<JSONArray> responseDTO = JSONObject.parseObject(HttpUtil.httpGet(getSemiSupOfferLogUrl + param), SemiResultDTO.class);
//            if (responseDTO.getSuccess() && responseDTO.getData().size() > 0) {
//                List<SemiSupOfferLogDTO> semiSupOfferLogDTOList = JSONObject.parseArray(responseDTO.getData().toJSONString(), SemiSupOfferLogDTO.class);
//                dcSemiSupplierOfferLogMapper.insertOrUpdateSemiSupplierOfferLog(semiSupOfferLogDTOList);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            logger.error(">>>>>获取半成品供应商报价流水出错" + e.getMessage());
//            isOk = false;
//        }
//        int rows = 5000;
//        int page = 1;
//        try {
//            param = "?btime=" + DateTimeUtil.dateToString(DateTimeUtil.addDays(datePlusOne, -3), DateTimeUtil.DATE_FORMAT) + "&etime=" + DateTimeUtil.dateToString(datePlusOne, DateTimeUtil.DATE_FORMAT);
//            SemiPageResultDTO responseDTO = JSONObject.parseObject(HttpUtil.httpGet(getSemiStockLogUrl + param +
//                    "&page=" + page + "&rows=" + rows), SemiPageResultDTO.class);
//            if (responseDTO.getSuccess() && responseDTO.getData().getTotalItems() > 0) {
//                dcSemiStockLogMapper.insertOrUpdateSemiStockLog(responseDTO.getData().getItems());
//                int totalPages = responseDTO.getData().getTotalPages();
//                responseDTO = null;
//                while (page < totalPages) {
//                    page += 1;
//                    try {
//                        responseDTO = JSONObject.parseObject(HttpUtil.httpGet(getSemiStockLogUrl + param + "&page=" + page + "&rows=" + rows), SemiPageResultDTO.class);
//                        if (responseDTO.getData() != null && responseDTO.getData().getItems() != null) {
//                            dcSemiStockLogMapper.insertOrUpdateSemiStockLog(responseDTO.getData().getItems());
//                        }
//                        responseDTO = null;
//                    } catch (Exception e) {
//                        e.printStackTrace();
//                        logger.error(">>>>>获取半成品库存流水出错，请求分页数：" + page + "\n" + e.getMessage());
//                        isOk = false;
//                        continue;
//                    }
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            logger.error(">>>>>获取半成品库存流水出错，请求分页数：" + page + "\n" + e.getMessage());
//            isOk = false;
//        }
//        // 生成半成品每日存货
//        if (isOk) {
////            if (dcSem/**/ iDailyStockMapper.query(date) != null){
//            dcSemiDailyStockMapper.insertSemiDailyStock(date);
//        }
//    }

    @Transactional(rollbackFor = Exception.class)
    public void syncPayPal() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeSyncPayPal);
        LocalDateTime dateTime = LocalDateTime.now().minusDays(1);

        List<PayPalBalanceDTO> payPalBalanceDTOList = cwApi.getPayPalBalance();
        if (ListUtil.isNotEmpty(payPalBalanceDTOList)) {
            List<DcPlatformBalance> dcPlatformBalanceList = payPalBalanceDTOList.stream()
                    .map(payPalBalanceDTO -> {
                        DcPlatformBalance dcPlatformBalance = new DcPlatformBalance();
                        dcPlatformBalance.setPaycompanyid(2);
                        dcPlatformBalance.setPlatformcode("Ebay");
                        dcPlatformBalance.setPlatformname("Ebay");
                        dcPlatformBalance.setAccount(payPalBalanceDTO.getAccount());
                        dcPlatformBalance.setCurrency(payPalBalanceDTO.getCurrencyCode());
                        dcPlatformBalance.setAmount(payPalBalanceDTO.getBalance());
                        dcPlatformBalance.setUserableAmount(payPalBalanceDTO.getBalance());
                        dcPlatformBalance.setFreezeAmount(BigDecimal.ZERO);
                        dcPlatformBalance.setExchangerate(BigDecimal.ZERO);
                        dcPlatformBalance.setAmountRmb(BigDecimal.ZERO);
                        dcPlatformBalance.setUserableAmountRmb(BigDecimal.ZERO);
                        dcPlatformBalance.setFreezeAmountRmb(BigDecimal.ZERO);
                        dcPlatformBalance.setDay(dateTime.toLocalDate());
                        dcPlatformBalance.setPuttime(dateTime);
                        dcPlatformBalance.setDelstatus(0);
                        dcPlatformBalance.setFromsource("PayPal");
                        dcPlatformBalance.setCreatetime(LocalDateTime.now());
                        dcPlatformBalance.setCreateuserid(0);
                        dcPlatformBalance.setCreateusername("admin");
                        return dcPlatformBalance;
                    })
                    .collect(Collectors.toList());

            dcPlatformBalanceService.remove(new LambdaQueryWrapper<DcPlatformBalance>()
                    .eq(DcPlatformBalance::getDay, dateTime.toLocalDate()));

            dcPlatformBalanceService.saveBatch(dcPlatformBalanceList);
            dcPlatformBalanceMapper.updatePayPalBalance(dateTime.toLocalDate());
        }


        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Resource
    DcBalanceSheetMapper dcBalanceSheetMapper;
    @Resource
    DcPlatformBalanceMapper dcPlatformBalanceMapper;
    @Resource
    DcFixedAssetsDetailMapper dcFixedAssetsDetailMapper;
    @Resource
    IDcBalanceSheetService dcBalanceSheetService;

    @Resource
    DcInventoryBalanceMapper dcInventoryBalanceMapper;
    @Resource
    DcSemiDailyStockMapper dcSemiDailyStockMapper;
    @Resource
    DcSemiDailyTransferMapper dcSemiDailyTransferMapper;
    @Resource
    DcExchangeRateMapper dcExchangeRateMapper;
    @Resource
    DcBalanceSheetNewMapper dcBalanceSheetNewMapper;
    @Resource
    DcBalanceSheetNewResultMapper dcBalanceSheetNewResultMapper;
    @Resource
    IDcBalanceSheetNewService dcBalanceSheetNewService;

    @Resource
    DcSemiSupplierOfferLogMapper dcSemiSupplierOfferLogMapper;
    @Resource
    DcSemiStockLogMapper dcSemiStockLogMapper;

    @Resource
    MjgysApi mjgysApi;

    @Resource
    MjzzApi mjzzApi;

    /**
     * 每天生成资产负债表
     * companyValue 0
     * companyName 百伦供应链
     *
     * <p>
     * 字段:银行账户余额汇总 {@link DcBalanceSheet#getBankAccountBalance()}
     * 取数 {@link DcBankAccountBalanceMapper#getBalanceSum(LocalDate)}
     * 银行账户数据从财务系统同步而来 {@link BalanceSheetService#syncBankAccount()}
     * </p>
     *
     * <p>
     * 字段:提现在途金额汇总 {@link DcBalanceSheet#getWithdrawAmount()}
     * 取数 {@link DcWithdrawOnWayMapper#getWithdrawOnWaySum(LocalDate)}
     * 提现在途数据从财务系统同步而来 {@link BalanceSheetService#syncWithdrawOnWaySummary()}
     * </p>
     *
     * <p>
     * 字段：第三方平台余额 {@link DcBalanceSheet#getPlatformBalance()}
     * 取数  {@link DcPlatformBalanceMapper#getPlatformBalanceSum(LocalDate)}
     * 第三方平台数据从财务系统同步 {@link BalanceSheetService#syncPayPal()} 现在不知道没启动 所以第三方平台余额都是0
     * </p>
     *
     * <p>
     * 字段：货币资金 {@link DcBalanceSheet#getMonetaryFund()}
     * 取数：货币资金 = 银行账户余额汇总 + 提现在途金额汇总 + 第三方平台余额
     * </p>
     *
     * <p>
     * 字段：短期借款 {@link DcBalanceSheet#getShortTermBorrow()}
     * 取数:  {@link DcShortTermBorrowMapper#getShortTermBorrowBalanceSum(LocalDate)}
     * 短期借款数据从财务系统同步过来 {@link BalanceSheetService#syncShortBorrowBalance}
     * </p>
     *
     * <p>
     * 字段:借支金额{@link DcBalanceSheet#getAmountBorrowed()}
     * 取数: {@link DcBalanceSheetMapper#getAmountBorrowed(LocalDate)}
     * 元数据实体 {@link DcDailyFee} 数据来源详见datacenter-sync-fee项目
     * </p>
     *
     * <p>
     * 字段：其他应收款{@link DcBalanceSheet#getOtherAccountsReceivable()}
     * 取数: {@link DcBalanceSheetMapper#getOtherAccountsReceivableImport(LocalDate)}(导入的其他应收款) + 借支金额
     * </p>
     *
     * <p>
     * 字段：固定资产
     * 取数： {@link DcBalanceSheetMapper#getFixedAssetsImport(LocalDate)}(导入的固定资产) + {@link DcFixedAssetsDetailMapper#getFixedAssetsSum(LocalDate)} (固定资产统计)
     * 固定资产统计 从费用系统采购单同步而来 {@link BalanceSheetService#syncBuy()}
     * </p>
     */
    @Transactional(rollbackFor = Exception.class)
    public void generateBalanceSheet() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeGenerateBalanceSheet);

        Integer companyValue = 0;
        String companyName = "百伦供应链";


        LocalDate date = LocalDate.now().minusDays(1);

        //取供应商往来数据：应付账款和预付账款
        getSupplierTransaction(date);

        //获取半成品在途
        getSemiTransferAmount(date);

        //货品库存
        dcInventoryBalanceMapper.insertInventoryBalance(date);
        //货品调拨在途
        dcInventoryBalanceMapper.insertTransferInventoryBalance(date);

        DcBalanceSheet dcBalanceSheet = dcBalanceSheetMapper.selectOne(new LambdaQueryWrapper<DcBalanceSheet>()
                .eq(DcBalanceSheet::getCompanyValue, companyValue)
                .eq(DcBalanceSheet::getCompanyName, companyName)
                .eq(DcBalanceSheet::getStatisticalTime, LocalDate.now().minusDays(1)));

        DcBalanceSheetNew dcBalanceSheetNew = dcBalanceSheetNewMapper.selectOne(new LambdaQueryWrapper<DcBalanceSheetNew>()
                .eq(DcBalanceSheetNew::getCompanyValue, companyValue)
                .eq(DcBalanceSheetNew::getCompanyName, companyName)
                .eq(DcBalanceSheetNew::getStatisticalTime, LocalDate.now().minusDays(1)));

        if (dcBalanceSheet == null) {
            dcBalanceSheet = new DcBalanceSheet();
            dcBalanceSheet.setCompanyValue(companyValue);
            dcBalanceSheet.setCompanyName(companyName);
            dcBalanceSheet.setStatisticalTime(LocalDate.now().minusDays(1));
        }

        if (dcBalanceSheetNew == null) {
            dcBalanceSheetNew = new DcBalanceSheetNew();
            dcBalanceSheetNew.setCompanyValue(companyValue);
            dcBalanceSheetNew.setCompanyName(companyName);
            dcBalanceSheetNew.setStatisticalTime(LocalDate.now().minusDays(1));
        }

        //银行账户余额汇总
        BigDecimal bankAccountBalanceSum = dcBankAccountBalanceMapper.getBalanceSum(date);
        dcBalanceSheet.setBankAccountBalance(bankAccountBalanceSum);
        dcBalanceSheetNew.setBankAccountBalance(bankAccountBalanceSum);

        // 提现在途金额汇总
        BigDecimal withdrawOnWaySum = dcWithdrawOnWayMapper.getWithdrawOnWaySum(date);
        dcBalanceSheet.setWithdrawAmount(withdrawOnWaySum);
        dcBalanceSheetNew.setWithdrawAmount(withdrawOnWaySum);

        // 第三方平台余额
        BigDecimal platformBalanceSum = dcPlatformBalanceMapper.getPlatformBalanceSum(date);
        dcBalanceSheet.setPlatformBalance(platformBalanceSum);
        dcBalanceSheetNew.setPlatformBalance(platformBalanceSum);

        // 货币资金  货币资金 = 银行余额 + 提现在途 + 第三方平台余额
        dcBalanceSheet.setMonetaryFund(bankAccountBalanceSum.add(withdrawOnWaySum).add(platformBalanceSum));
        dcBalanceSheetNew.setMonetaryFund(bankAccountBalanceSum.add(withdrawOnWaySum).add(platformBalanceSum));

        // 短期借款
        BigDecimal shortBorrowBalanceSum = dcShortTermBorrowMapper.getShortTermBorrowBalanceSum(date);
        dcBalanceSheet.setShortTermBorrow(shortBorrowBalanceSum);
        dcBalanceSheetNew.setShortTermBorrow(shortBorrowBalanceSum);

        //借支金额(借支单未还金额)
        BigDecimal amountBorrowedSum = dcBalanceSheetMapper.getAmountBorrowed(date);
        dcBalanceSheet.setAmountBorrowed(amountBorrowedSum);
        dcBalanceSheetNew.setAmountBorrowed(amountBorrowedSum);

        // 其他应收款
        BigDecimal otherAccountsReceivableImport = dcBalanceSheetMapper.getOtherAccountsReceivableImport(date);
        dcBalanceSheet.setOtherAccountsReceivable(amountBorrowedSum.add(otherAccountsReceivableImport));
        dcBalanceSheetNew.setOtherAccountsReceivable(amountBorrowedSum.add(otherAccountsReceivableImport));

        //固定资产
        BigDecimal fixedAssetsSum = dcFixedAssetsDetailMapper.getFixedAssetsSum(date);
        BigDecimal fixedAssetsImport = dcBalanceSheetMapper.getFixedAssetsImport(date);
        dcBalanceSheet.setFixedAssets(fixedAssetsSum.add(fixedAssetsImport));
        dcBalanceSheetNew.setFixedAssets(fixedAssetsSum.add(fixedAssetsImport));

        // FBA在库金额
        BigDecimal fbaInventoryAmountSum = dcInventoryBalanceMapper.getFbaInventoryAmountSum(date);
        dcBalanceSheet.setFbaInventoryAmount(fbaInventoryAmountSum);
        dcBalanceSheetNew.setFbaInventoryAmount(fbaInventoryAmountSum);

        // 非FBA在库金额(不包含耗材仓)
        BigDecimal notFbaInventoryAmountSum = dcInventoryBalanceMapper.getNotFbaInventoryAmountSum(date);
        dcBalanceSheet.setNotFbaInventoryAmount(notFbaInventoryAmountSum);
        dcBalanceSheetNew.setNotFbaInventoryAmount(notFbaInventoryAmountSum);

        // 非FBA在库金额(耗材仓)
        BigDecimal notFbaHcInventoryAmountSum = dcInventoryBalanceMapper.getNotFbaHcInventoryAmountSum(date);
        dcBalanceSheet.setNotFbaHcInventoryAmount(notFbaHcInventoryAmountSum);
        dcBalanceSheetNew.setNotFbaHcInventoryAmount(notFbaHcInventoryAmountSum);

        // FBA在途
        BigDecimal fbaTransferAmountSum = dcInventoryBalanceMapper.getFbaTransferAmountSum(date);
        dcBalanceSheet.setFbaTransferAmount(fbaTransferAmountSum);
        dcBalanceSheetNew.setFbaTransferAmount(fbaTransferAmountSum);

        // 非FBA在途金额(调拨+采购)
        BigDecimal notFbaTransferAmountSum = dcInventoryBalanceMapper.getNotFbaTransferAmountSum(date);
        dcBalanceSheet.setNotFbaTransferAmount(notFbaTransferAmountSum);
        dcBalanceSheetNew.setNotFbaTransferAmount(notFbaTransferAmountSum);

        // FBA调拨在途金额(调拨不包含计划)
        BigDecimal fbaTransferAllotAmountSum = dcInventoryBalanceMapper.getFbaTransferAllotAmountSum(date);
        dcBalanceSheet.setFbaTransferAllotAmount(fbaTransferAllotAmountSum);
        dcBalanceSheetNew.setFbaTransferAllotAmount(fbaTransferAllotAmountSum);

        // 非FBA调拨在途金额(调拨不包含计划)
        BigDecimal notFbaTransferAllotAmountSum = dcInventoryBalanceMapper.getNotFbaTransferAllotAmountSum(date);
        dcBalanceSheet.setNotFbaTransferAllotAmount(notFbaTransferAllotAmountSum);
        dcBalanceSheetNew.setNotFbaTransferAllotAmount(notFbaTransferAllotAmountSum);

        // FBA调拨计划在途金额
        BigDecimal fbaTransferPlanAmountSum = dcInventoryBalanceMapper.getFbaTransferPlanAmountSum(date);
        dcBalanceSheet.setFbaTransferPlanAmount(fbaTransferPlanAmountSum);
        dcBalanceSheetNew.setFbaTransferPlanAmount(fbaTransferPlanAmountSum);

        // 非FBA调拨计划在途金额
        BigDecimal notFbaTransferPlanAmountSum = dcInventoryBalanceMapper.getNotFbaTransferPlanAmountSum(date);
        dcBalanceSheet.setNotFbaTransferPlanAmount(notFbaTransferPlanAmountSum);
        dcBalanceSheetNew.setNotFbaTransferPlanAmount(notFbaTransferPlanAmountSum);

        // FBA采购在途金额
        BigDecimal fbaPurchaseAmountSum = dcInventoryBalanceMapper.getFbaPurchaseAmountSum(date);
        if (fbaPurchaseAmountSum == null) fbaPurchaseAmountSum = BigDecimal.ZERO;
        dcBalanceSheet.setFbaPurchaseAmount(fbaPurchaseAmountSum);
        dcBalanceSheetNew.setFbaPurchaseAmount(fbaPurchaseAmountSum);

        // 非FBA采购在途金额
        BigDecimal notFbaPurchaseAmountSum = dcInventoryBalanceMapper.getNotFbaPurchaseAmountSum(date);
        dcBalanceSheet.setNotFbaPurchaseAmount(notFbaPurchaseAmountSum);
        dcBalanceSheetNew.setNotFbaPurchaseAmount(notFbaPurchaseAmountSum);

        // 自产采购在途金额
        BigDecimal purchaseProAmountSum = dcInventoryBalanceMapper.getPurchaseProAmount(date);
        dcBalanceSheet.setPurchaseProAmount(purchaseProAmountSum);
        dcBalanceSheetNew.setPurchaseProAmount(purchaseProAmountSum);

        // 半成品在库金额
        BigDecimal semiInventoryAmountSum = dcSemiDailyStockMapper.getSemiDailyStockSum(date);
        dcBalanceSheet.setSemiInventoryAmount(semiInventoryAmountSum);
        dcBalanceSheetNew.setSemiInventoryAmount(semiInventoryAmountSum);

        //半成品在库金额=百伦
        BigDecimal semiBailunInventoryAmountSum = dcSemiDailyStockMapper.getSemiBailunDailyStockSum(date);
        dcBalanceSheet.setSemiBailunInventoryAmount(semiBailunInventoryAmountSum);
        dcBalanceSheetNew.setSemiBailunInventoryAmount(semiBailunInventoryAmountSum);

        //半成品在库金额-哈尼曼
        BigDecimal semiHaNiInventoryAmountSum = dcSemiDailyStockMapper.getSemiHaNiDailyStockSum(date);
        dcBalanceSheet.setSemiHaniInventoryAmount(semiHaNiInventoryAmountSum);
        dcBalanceSheetNew.setSemiHaniInventoryAmount(semiHaNiInventoryAmountSum);

        //半成品生产在库金额
        BigDecimal semiProdInventoryAmountSum = dcSemiDailyStockMapper.getSemiProdInventoryAmountSum(date);
        dcBalanceSheet.setSemiProdInventoryAmount(semiProdInventoryAmountSum);
        dcBalanceSheetNew.setSemiProdInventoryAmount(semiProdInventoryAmountSum);

        // 半成品在途金额 恢复,不汇总进去存货里面
        BigDecimal semiTransferAmountSum = dcSemiDailyTransferMapper.getSemiDailyTransferSum(date);
        dcBalanceSheet.setSemiTransferAmount(semiTransferAmountSum);
        dcBalanceSheetNew.setSemiTransferAmount(semiTransferAmountSum);

        //半成品在途金额=百伦
        BigDecimal semiBailunTransferAmountSum = dcSemiDailyTransferMapper.getSemiBailunDailyTransferSum(date);
        dcBalanceSheet.setSemiBailunTransferAmount(semiBailunTransferAmountSum);
        dcBalanceSheetNew.setSemiBailunTransferAmount(semiBailunTransferAmountSum);

        //半成品在途金额=哈尼曼
        BigDecimal semiHaNiTransferAmountSum = dcSemiDailyTransferMapper.getSemiHaNiDailyTransferSum(date);
        dcBalanceSheet.setSemiHaniTransferAmount(semiHaNiTransferAmountSum);
        dcBalanceSheetNew.setSemiHaniTransferAmount(semiHaNiTransferAmountSum);

        // 存货 金额  FBA在库金额+非FBA在库金额(不包含耗材仓)+FBA调拨在途金额(不包含调拨计划)+非FBA调拨在途金额(不包含调拨计划)+半成品在库金额+半成品生产在库金额+自产采购在途
        BigDecimal inventoryBalanceSum = fbaInventoryAmountSum.add(notFbaInventoryAmountSum).add(fbaTransferAllotAmountSum).add(notFbaTransferAllotAmountSum).add(semiBailunInventoryAmountSum).add(semiProdInventoryAmountSum).add(purchaseProAmountSum);
        dcBalanceSheet.setInventoryAmount(inventoryBalanceSum);
        dcBalanceSheetNew.setInventoryAmount(inventoryBalanceSum);

        //其他应收款 还不知道哪里来的
        dcBalanceSheetNew.setAccountsReceivable(dcBalanceSheet.getAccountsReceivable());

        dcBalanceSheetService.saveOrUpdate(dcBalanceSheet);
        dcBalanceSheetNewService.saveOrUpdate(dcBalanceSheetNew);

        //更新任务时间
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }


    @Resource
    PurchaseApi purchaseApi;
    @Resource
    DcSupplierTransactionMapper dcSupplierTransactionMapper;
    @Resource
    DcLogisticsSupplierTransactionMapper dcLogisticsSupplierTransactionMapper;

    /**
     *取供应商往来数据：应付账款和预付账款
     */
    public void getSupplierTransaction(LocalDate date){
        try {
            PurchaseResult<List<SupplierTransactionDTO>> result = purchaseApi.GetSupplierTransactionStatictis(date, null, null, "{}");
            log.info("取供应商往来数据：应付账款和预付账款");
            log.info(date.toString());
            log.info(JSON.toJSONString(result));
            if (result.getIsSuccessed() && result.getData().size() > 0) {
                dcSupplierTransactionMapper.insertOrUpdateSupplierTransaction(result.getData());
                updateSuppliserTransactionOfBalanceSheet(date);
            }
        }catch (Exception ex){
            log.error(ex.toString());
            try {
                throw new Exception("取供应商往来数据时发生异常");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Transactional
    public void adjustSupplierTransaction(List<SupplierTransactionDTO> supplierTransactionDTOList) {
        dcSupplierTransactionMapper.insertOrUpdateSupplierTransaction(supplierTransactionDTOList);
        Set<LocalDate> updateDateSet = new HashSet<>();
        for (SupplierTransactionDTO supplierTransactionDTO : supplierTransactionDTOList) {
            updateDateSet.add(supplierTransactionDTO.getDay());
        }
        for (LocalDate date : updateDateSet) {
            updateSuppliserTransactionOfBalanceSheet(date);
        }
    }

    /**
     * 更新调整后的物流供应商往来数据，以及资产负债表中的应付账款和预付账款
     */
    @Transactional
    public void adjustLogisticsSupplierTransaction(List<LogisticsSupplierTransactionDTO> logisticsSupplierTransactionDTOList) {
        dcLogisticsSupplierTransactionMapper.insertOrUpdateLogisticsSupplierTransaction(logisticsSupplierTransactionDTOList);
        Set<LocalDate> updateDateSet = new HashSet<>();
        LocalDate dataDate = null;
        List<LogisticsSupplierTransactionDTO> weekendData = new ArrayList<>();
        for (LogisticsSupplierTransactionDTO logisticsSupplierTransactionDTO : logisticsSupplierTransactionDTOList) {
            dataDate = logisticsSupplierTransactionDTO.getDay();
            updateDateSet.add(dataDate);
            // 由于周六日数据取自周五数据，因此逢更新周五数据，则自动更新周末数据
            if (dataDate.getDayOfWeek().equals(DayOfWeek.FRIDAY)) {
                // 星期六数据
                dataDate = dataDate.plusDays(1);
                logisticsSupplierTransactionDTO.setDay(dataDate);
                weekendData.add(logisticsSupplierTransactionDTO);
                updateDateSet.add(dataDate);
            }
        }
        if (weekendData.size() > 0) {
            // 插入或更新星期六数据
            dcLogisticsSupplierTransactionMapper.insertOrUpdateLogisticsSupplierTransaction(weekendData);
            // 星期日数据
            for (LogisticsSupplierTransactionDTO weekendDTO : weekendData) {
                dataDate = weekendDTO.getDay();
                dataDate = dataDate.plusDays(1);
                weekendDTO.setDay(dataDate);
                updateDateSet.add(dataDate);
            }
            // 插入或更新星期日数据
            dcLogisticsSupplierTransactionMapper.insertOrUpdateLogisticsSupplierTransaction(weekendData);
        }
        for (LocalDate date : updateDateSet) {
            updateSuppliserTransactionOfBalanceSheet(date);
        }
    }

    /**
     * 获取物流供应商往来数据：应付账款和预付账款
     *
     */
    public void getLogisticsSupplierTransaction() {
        LocalDate date = LocalDate.now();
        // 逢周六日，取周五数据
        boolean isWeek = false;
        LocalDate dataDate = null; // 数据的标识日期

        if (date.getDayOfWeek().equals(DayOfWeek.SATURDAY)) {
            isWeek = true;
            dataDate = date;
            date = date.minusDays(1);
        } else if (date.getDayOfWeek().equals(DayOfWeek.SUNDAY)) {
            isWeek = true;
            dataDate = date;
            date = date.minusDays(2);
        }
        try {
            PurchaseResult<List<LogisticsSupplierTransactionDTO>> result = purchaseApi.GetSupplierTransactionExpress(date,"{}");
            if (result.getIsSuccessed() && result.getData().size() > 0) {
                if (isWeek) {
                    for (LogisticsSupplierTransactionDTO logisticsSupplierTransactionDTO : result.getData()) {
                        logisticsSupplierTransactionDTO.setDay(dataDate);
                    }
                }
                dcLogisticsSupplierTransactionMapper.insertOrUpdateLogisticsSupplierTransaction(result.getData());
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error(">>>>>获取物流供应商往来数据出错" + e.getMessage());
        }
    }

    public void updateSheetSuppliserTransaction(String dateStr,
                                                BigDecimal logisticsPayableSum,
                                                BigDecimal accountsReceivableUpdate,
                                                BigDecimal accountsReceivableImport,
                                                BigDecimal otherAccountsReceivableImport,
                                                BigDecimal otherAccountsPayableImport,
                                                BigDecimal fixedAssetsImport,
                                                BigDecimal ncaDeferredTaxAssetsImport,
                                                BigDecimal platformBalanceUpdate) throws ParseException {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate date = LocalDate.parse(dateStr,dtf);
        // 生成资产负债表
        DcBalanceSheet dcBalanceSheetInit = dcBalanceSheetMapper.getDcBalanceSheetInit(0, "百伦供应链", date);
        if (dcBalanceSheetInit == null) {
            dcBalanceSheetMapper.insertBalanceSheet(0, "百伦供应链", date);
        }
        DcBalanceSheet dcBalanceSheet = new DcBalanceSheet();//物流供应商、成品供应商、半成品供应商
        if (logisticsPayableSum != null) {
            // 成品供应商应付款项
            BigDecimal finishedAccountsPayableSum = dcSupplierTransactionMapper.getFinishedAccountsPayableSum(date);
            if (finishedAccountsPayableSum == null) {
                finishedAccountsPayableSum = dcBalanceSheetMapper.getFinashedAccountSumByOld(date);
            }
            dcBalanceSheet.setFinishedAccountsPayable(finishedAccountsPayableSum);
            // 半成品供应商应付款项
            BigDecimal semiAccountsPayableSum = dcSupplierTransactionMapper.getSemiAccountsPayableSum(date);
            if (semiAccountsPayableSum == null) semiAccountsPayableSum = BigDecimal.ZERO;
            dcBalanceSheet.setSemiAccountsPayable(semiAccountsPayableSum);
            // 物流供应商应付款项
            dcBalanceSheet.setLogisticsAccountsPayable(logisticsPayableSum);
            // 应付款项
            BigDecimal accountsPayableSum = finishedAccountsPayableSum.add(semiAccountsPayableSum).add(logisticsPayableSum);
            dcBalanceSheet.setAccountsPayable(accountsPayableSum);
        }

        if (accountsReceivableUpdate != null) {
            // 应收款项--计算更改
            BigDecimal accountsReceivableImportSum = dcBalanceSheetMapper.getAccountsReceivableImport(date);
            if (accountsReceivableImportSum == null) accountsReceivableImportSum = BigDecimal.ZERO;
            dcBalanceSheet.setAccountsReceivableUpdate(accountsReceivableUpdate);
            dcBalanceSheet.setAccountsReceivable(accountsReceivableUpdate.add(accountsReceivableImportSum));
        }

        if (accountsReceivableImport != null) {
            // 应收款项
            BigDecimal accountsReceivableUpdateSum = dcBalanceSheetMapper.getAccountsReceivableUpdate(date);
            if (accountsReceivableUpdateSum == null) {
                accountsReceivableUpdateSum = dcSupplierTransactionMapper.getAccountsReceivable(date);
                if (accountsReceivableUpdateSum == null) accountsReceivableUpdateSum = BigDecimal.ZERO;
            }
            dcBalanceSheet.setAccountsReceivableImport(accountsReceivableImport);
            dcBalanceSheet.setAccountsReceivable(accountsReceivableUpdateSum.add(accountsReceivableImport));
        }

        if (otherAccountsReceivableImport != null) {
            // 借支单未还金额
            BigDecimal amountBorrowedSum = dcBalanceSheetMapper.getAmountBorrowed(date);
            if (amountBorrowedSum == null) amountBorrowedSum = BigDecimal.ZERO;
            dcBalanceSheet.setAmountBorrowed(amountBorrowedSum);
            // 其他应收款
            /*BigDecimal otherAccountsReceivable = dcOtherCostMapper.getOtherAccountsReceivableSum(date); // 其他应收款(加借支单未还金额)
            if(otherAccountsReceivable == null) otherAccountsReceivable = BigDecimal.ZERO;*/
            dcBalanceSheet.setOtherAccountsReceivableImport(otherAccountsReceivableImport);
            dcBalanceSheet.setOtherAccountsReceivable(amountBorrowedSum.add(otherAccountsReceivableImport));
        }

        if (otherAccountsPayableImport != null) {
            // 其他应付款
            /*BigDecimal otherAccountsPayable = dcOtherCostMapper.getOtherAccountsPayableSum(date);
            if(otherAccountsPayable == null) otherAccountsPayable = BigDecimal.ZERO;*/
            dcBalanceSheet.setOtherAccountsPayableImport(otherAccountsPayableImport);
            dcBalanceSheet.setOtherAccountsPayable(otherAccountsPayableImport);
        }

        if (fixedAssetsImport != null) {
            // 固定资产
            BigDecimal fixedAssetsSum = dcFixedAssetsDetailMapper.getFixedAssetsSum(date);
            if (fixedAssetsSum == null) fixedAssetsSum = BigDecimal.ZERO;
            dcBalanceSheet.setFixedAssetsImport(fixedAssetsImport);
            dcBalanceSheet.setFixedAssets(fixedAssetsSum.add(fixedAssetsImport));
        }

        if (ncaDeferredTaxAssetsImport != null) {
            // 递延所得税资产
            dcBalanceSheet.setNcaDeferredTaxAssetsImport(ncaDeferredTaxAssetsImport);
            dcBalanceSheet.setNcaDeferredTaxAssets(ncaDeferredTaxAssetsImport);
        }

        if (platformBalanceUpdate != null) {
            // 银行账户余额汇总
            BigDecimal bankAccountBalanceSum = dcBankAccountBalanceMapper.getBalanceSum(date);
            if (bankAccountBalanceSum == null) bankAccountBalanceSum = BigDecimal.ZERO;
            dcBalanceSheet.setBankAccountBalance(bankAccountBalanceSum);
            // 提现在途金额汇总
            BigDecimal withdrawOnWaySum = dcWithdrawOnWayMapper.getWithdrawOnWaySum(date);
            if (withdrawOnWaySum == null) withdrawOnWaySum = BigDecimal.ZERO;
            dcBalanceSheet.setWithdrawAmount(withdrawOnWaySum);
            // 第三方平台余额
            dcBalanceSheet.setPlatformBalance(platformBalanceUpdate);
            // 货币资金
            dcBalanceSheet.setMonetaryFund(bankAccountBalanceSum.add(withdrawOnWaySum).add(platformBalanceUpdate)); // 货币资金 = 银行余额 + 提现在途 + 第三方平台余额
        }
        dcBalanceSheet.setCompanyValue(0);
        dcBalanceSheet.setStatisticalTime(date);
        dcBalanceSheetMapper.updateByCompanyAndDaySelective(dcBalanceSheet);
    }

    public void updateSuppliserTransactionOfBalanceSheet(LocalDate date) {
        DcBalanceSheet dcBalanceSheet = new DcBalanceSheet();//物流供应商、成品供应商、半成品供应商
        // 成品供应商应付款项
        BigDecimal finishedAccountsPayableSum = dcSupplierTransactionMapper.getFinishedAccountsPayableSum(date);
        if (finishedAccountsPayableSum == null) {
            finishedAccountsPayableSum = dcBalanceSheetMapper.getFinashedAccountSumByOld(date);
        }
        dcBalanceSheet.setFinishedAccountsPayable(finishedAccountsPayableSum);
        // 半成品供应商应付款项
        BigDecimal semiAccountsPayableSum = dcSupplierTransactionMapper.getSemiAccountsPayableSum(date);
        if (semiAccountsPayableSum == null) semiAccountsPayableSum = BigDecimal.ZERO;
        dcBalanceSheet.setSemiAccountsPayable(semiAccountsPayableSum);
        // 物流供应商应付款项
        BigDecimal logisticsAccountsPayableSum = dcBalanceSheetMapper.getLogisticsAccountsPayableInit(date);
        if (logisticsAccountsPayableSum == null || logisticsAccountsPayableSum.compareTo(BigDecimal.ZERO) == 0) {
            logisticsAccountsPayableSum = dcBalanceSheetMapper.getLogisticsAccountsPayableSum(date);
            if (logisticsAccountsPayableSum == null) {
                logisticsAccountsPayableSum = dcBalanceSheetMapper.getLogisticsAccountsPayableSumByOld(date);
            }
        }
        dcBalanceSheet.setLogisticsAccountsPayable(logisticsAccountsPayableSum);
        // 应付款项
        BigDecimal accountsPayableSum = finishedAccountsPayableSum.add(semiAccountsPayableSum).add(logisticsAccountsPayableSum);
        dcBalanceSheet.setAccountsPayable(accountsPayableSum);
        // 应收款项
        BigDecimal accountsReceivableSum = dcBalanceSheetMapper.getAccountsReceivableImport(date);
        if (accountsReceivableSum == null || accountsReceivableSum.compareTo(BigDecimal.ZERO) == 0) {
            accountsReceivableSum = dcSupplierTransactionMapper.getAccountsReceivable(date);
            if (accountsReceivableSum == null) accountsReceivableSum = BigDecimal.ZERO;
        }
        dcBalanceSheet.setAccountsReceivable(accountsReceivableSum);
        // 成品供应商预付款项
        BigDecimal finishedPrepaymentSum = dcSupplierTransactionMapper.getFinishedPrepaymentSum(date);
        if (finishedPrepaymentSum == null) finishedPrepaymentSum = BigDecimal.ZERO;
        dcBalanceSheet.setFinishedPrepayment(finishedPrepaymentSum);
        // 半成品供应商预付款项
        BigDecimal semiPrepaymentSum = dcSupplierTransactionMapper.getSemiPrepaymentSum(date);
        if (semiPrepaymentSum == null) semiPrepaymentSum = BigDecimal.ZERO;
        dcBalanceSheet.setSemiPrepayment(semiPrepaymentSum);
        // 物流供应商预付款项
        BigDecimal logisticsPrepaymentSum = dcLogisticsSupplierTransactionMapper.getLogisticsPrepaymentSum(date);
        if (logisticsPrepaymentSum == null) logisticsPrepaymentSum = BigDecimal.ZERO;
        dcBalanceSheet.setLogisticsPrepayment(logisticsPrepaymentSum);
        // 预付款项
        BigDecimal prepaymentSum = finishedPrepaymentSum.add(semiPrepaymentSum).add(logisticsPrepaymentSum);
        dcBalanceSheet.setPrepayment(prepaymentSum);

        dcBalanceSheet.setCompanyValue(0);
        dcBalanceSheet.setStatisticalTime(date);
        dcBalanceSheetMapper.updateByCompanyAndDaySelective(dcBalanceSheet);
    }

    /**
     * <p>
     * 获取半成品存货
     * </p>
     */
    @Transactional(rollbackFor = Exception.class)
    public void syncSemiInventoryBalance() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncSemiStock);
        boolean isOk = true;
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String startDate = LocalDate.now().minusDays(1).format(dtf);
        String endDate = LocalDate.now().format(dtf);
        try {
            MjgysResult<List<SupofferLogResp>> supofferLogs = mjgysApi.supofferLog(startDate, endDate);
            if (supofferLogs.isSuccess() && supofferLogs.getData().size() > 0) {
                dcSemiSupplierOfferLogMapper.insertOrUpdateSemiSupplierOfferLog(supofferLogs.getData());
            }
        } catch (Exception e) {
            log.info(e.toString());
            e.printStackTrace();
            isOk = false;
        }
        int rows = 5000;
        int page = 1;
        try {
            MjzzResult<MjzzPage<StockLogResp>> stockLogResult = mjzzApi.stockLog(page, rows, startDate, endDate);
            if (stockLogResult.getSuccess() && stockLogResult.getData().getTotalItems() > 0) {
                dcSemiStockLogMapper.insertOrUpdateSemiStockLog(stockLogResult.getData().getItems());
                int totalPages = stockLogResult.getData().getTotalPages();
                stockLogResult = null;
                while (page < totalPages) {
                    page += 1;
                    try {
                        stockLogResult = mjzzApi.stockLog(page, rows, startDate, endDate);
                        if (stockLogResult.getData() != null && stockLogResult.getData().getItems() != null) {
                            dcSemiStockLogMapper.insertOrUpdateSemiStockLog(stockLogResult.getData().getItems());
                        }
                        stockLogResult = null;
                    } catch (Exception e) {
                        e.printStackTrace();
                        isOk = false;
                        continue;
                    }
                }
            }
        } catch (Exception e) {
            log.info(e.toString());
            isOk = false;
        }
        // 生成半成品每日存货
        if (isOk) {
            dcSemiDailyStockMapper.insertSemiDailyStock(LocalDate.now().minusDays(1));
        }
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Resource
    MjcgApi mjcgApi;
    @Resource
    DcSemiPurchaseDetailMapper dcSemiPurchaseDetailMapper;
    /**
     * 获取半成品在途
     */
    @Transactional(rollbackFor = Exception.class)
    public void getSemiTransferAmount(LocalDate start){
        boolean isOk = true;
        int page = 1;
        int row = 4000;
        MjcgResult<SemiPurchaseDetailPageInfoDTO> result = mjcgApi.GetBuyDetailList(start,start.plusDays(1),page,row);
        if (result.getResult() && result.getList().getTotalItems() > 0) {
            dcSemiPurchaseDetailMapper.insertOrUpdateSemiPurchaseDetail(result.getList().getItems());
            int totalPages = result.getList().getTotalPages();
            result = null;
            while (page < totalPages) {
                page += 1;
                try {
                    result = mjcgApi.GetBuyDetailList(start,start.plusDays(1),page,row);
                    dcSemiPurchaseDetailMapper.insertOrUpdateSemiPurchaseDetail(result.getList().getItems());
                    result = null;
                } catch (Exception e) {
                    e.printStackTrace();
                    log.error(">>>>>获取半成品采购明细出错，请求分页数：" + page + "\n" + e.getMessage());
                    isOk = false;
                    continue;
                }
            }
        }
        if (isOk) {
            dcSemiDailyTransferMapper.insertSemiDailyTransfer(start);
        }
    }

    @Resource
    IDcBalanceSheetNewResultService dcBalanceSheetNewResultService;
    @Resource
    DcBalanceSheetNewModifyMapper dcBalanceSheetNewModifyMapper;

    public void generateBalanceSheetNewResult() {
        //DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(financeGenerateBalanceSheetNewResult);

        Integer companyValue = 0;
        String companyName = "百伦供应链";


        LocalDate date = LocalDate.now().minusDays(1);

        this.setBalanceSheetNewResult(date);
        //更新任务时间
        //dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    public void setBalanceSheetNewResult(LocalDate statisticalTime) {

        Integer companyValue = 0;
        String companyName = "百伦供应链";


        DcBalanceSheetNewResult dcBalanceSheetNewResult = dcBalanceSheetNewResultMapper.selectOne(new LambdaQueryWrapper<DcBalanceSheetNewResult>()
                .eq(DcBalanceSheetNewResult::getCompanyValue, companyValue)
                .eq(DcBalanceSheetNewResult::getCompanyName, companyName)
                .eq(DcBalanceSheetNewResult::getStatisticalTime, statisticalTime));

        DcBalanceSheetNewModify dcBalanceSheetNewModify = dcBalanceSheetNewModifyMapper.selectOne(new LambdaQueryWrapper<DcBalanceSheetNewModify>()
                .eq(DcBalanceSheetNewModify::getCompanyValue, companyValue)
                .eq(DcBalanceSheetNewModify::getCompanyName, companyName)
                .eq(DcBalanceSheetNewModify::getStatisticalTime, statisticalTime));

        DcBalanceSheetNew dcBalanceSheetNew = dcBalanceSheetNewMapper.selectOne(new LambdaQueryWrapper<DcBalanceSheetNew>()
                .eq(DcBalanceSheetNew::getCompanyValue, companyValue)
                .eq(DcBalanceSheetNew::getCompanyName, companyName)
                .eq(DcBalanceSheetNew::getStatisticalTime, statisticalTime));

        if (dcBalanceSheetNewResult == null) {
            dcBalanceSheetNewResult = new DcBalanceSheetNewResult();
            dcBalanceSheetNewResult.setCompanyValue(companyValue);
            dcBalanceSheetNewResult.setCompanyName(companyName);
            dcBalanceSheetNewResult.setStatisticalTime(statisticalTime);
        }

        if (dcBalanceSheetNewModify == null) {
            dcBalanceSheetNewModify = new DcBalanceSheetNewModify();
            dcBalanceSheetNewModify.setCompanyValue(companyValue);
            dcBalanceSheetNewModify.setCompanyName(companyName);
            dcBalanceSheetNewModify.setStatisticalTime(statisticalTime);
            dcBalanceSheetNewModifyMapper.insert(dcBalanceSheetNewModify);
            dcBalanceSheetNewModify = dcBalanceSheetNewModifyMapper.selectById(dcBalanceSheetNewModify.getId());
        }
        if (dcBalanceSheetNew == null) {
            dcBalanceSheetNew = new DcBalanceSheetNew();
        }

        //银行账户余额汇总
        dcBalanceSheetNewResult.setBankAccountBalance(dcBalanceSheetNew.getBankAccountBalance()
                .add(dcBalanceSheetNewModify.getBankAccountBalance()));

        // 提现在途金额汇总
        dcBalanceSheetNewResult.setWithdrawAmount(dcBalanceSheetNew.getWithdrawAmount()
                .add(dcBalanceSheetNewModify.getWithdrawAmount()));

        // 第三方平台余额
        dcBalanceSheetNewResult.setPlatformBalance(dcBalanceSheetNew.getPlatformBalance()
                .add(dcBalanceSheetNewModify.getPlatformBalance()));

        // 货币资金  货币资金 = 银行余额 + 提现在途 + 第三方平台余额
        dcBalanceSheetNewResult.setMonetaryFund(dcBalanceSheetNew.getMonetaryFund()
                .add(dcBalanceSheetNewModify.getMonetaryFund()));

        // 短期借款
        dcBalanceSheetNewResult.setShortTermBorrow(dcBalanceSheetNew.getShortTermBorrow()
                .add(dcBalanceSheetNewModify.getShortTermBorrow()));

        //借支金额(借支单未还金额)
        dcBalanceSheetNewResult.setAmountBorrowed(dcBalanceSheetNew.getAmountBorrowed()
                .add(dcBalanceSheetNewModify.getAmountBorrowed()));

        // 其他应收款
        dcBalanceSheetNewResult.setOtherAccountsReceivable(dcBalanceSheetNew.getOtherAccountsReceivable()
                .add(dcBalanceSheetNewModify.getOtherAccountsReceivable()));

        //固定资产
        dcBalanceSheetNewResult.setFixedAssets(dcBalanceSheetNew.getFixedAssets()
                .add(dcBalanceSheetNewModify.getFixedAssets()));

//        // 货品库存
//        dcInventoryBalanceMapper.deleteInventoryBalance(date);
//        dcInventoryBalanceMapper.insertInventoryBalance(date);
//
//        // 货品调拨在途
//        dcInventoryBalanceMapper.insertTransferInventoryBalance(date);

        // FBA在库金额
        dcBalanceSheetNewResult.setFbaInventoryAmount(dcBalanceSheetNew.getFbaInventoryAmount()
                .add(dcBalanceSheetNewModify.getFbaInventoryAmount()));

        // 非FBA在库金额(不包含耗材仓)
        dcBalanceSheetNewResult.setNotFbaInventoryAmount(dcBalanceSheetNew.getNotFbaInventoryAmount()
                .add(dcBalanceSheetNewModify.getNotFbaHcInventoryAmount()));

        // 非FBA在库金额(耗材仓)
        dcBalanceSheetNewResult.setNotFbaHcInventoryAmount(dcBalanceSheetNew.getNotFbaHcInventoryAmount()
                .add(dcBalanceSheetNewModify.getNotFbaHcInventoryAmount()));

        // FBA在途
        dcBalanceSheetNewResult.setFbaTransferAmount(dcBalanceSheetNew.getFbaTransferAmount()
                .add(dcBalanceSheetNewModify.getFbaTransferAmount()));

        // 非FBA在途金额(调拨+采购)
        dcBalanceSheetNewResult.setNotFbaTransferAmount(dcBalanceSheetNew.getNotFbaTransferAmount()
                .add(dcBalanceSheetNewModify.getNotFbaTransferAmount()));

        // FBA调拨在途金额(调拨不包含计划)
        dcBalanceSheetNewResult.setFbaTransferAllotAmount(dcBalanceSheetNew.getFbaTransferAllotAmount()
                .add(dcBalanceSheetNewModify.getFbaTransferAllotAmount()));

        // 非FBA调拨在途金额(调拨不包含计划)
        dcBalanceSheetNewResult.setNotFbaTransferAllotAmount(dcBalanceSheetNew.getNotFbaTransferAllotAmount()
                .add(dcBalanceSheetNewModify.getNotFbaTransferAllotAmount()));

        // FBA调拨计划在途金额
        dcBalanceSheetNewResult.setFbaTransferPlanAmount(dcBalanceSheetNew.getFbaTransferPlanAmount()
                .add(dcBalanceSheetNewModify.getFbaTransferPlanAmount()));

        // 非FBA调拨计划在途金额
        dcBalanceSheetNewResult.setNotFbaTransferPlanAmount(dcBalanceSheetNew.getNotFbaTransferPlanAmount()
                .add(dcBalanceSheetNewModify.getNotFbaTransferPlanAmount()));

        // FBA采购在途金额
        dcBalanceSheetNewResult.setFbaPurchaseAmount(dcBalanceSheetNew.getFbaPurchaseAmount()
                .add(dcBalanceSheetNewModify.getFbaPurchaseAmount()));

        // 非FBA采购在途金额
        dcBalanceSheetNewResult.setNotFbaPurchaseAmount(dcBalanceSheetNew.getNotFbaPurchaseAmount()
                .add(dcBalanceSheetNewModify.getNotFbaPurchaseAmount()));

        // 自产采购在途金额
        dcBalanceSheetNewResult.setPurchaseProAmount(dcBalanceSheetNew.getPurchaseProAmount()
                .add(dcBalanceSheetNewModify.getPurchaseProAmount()));

        // 半成品在库金额
        dcBalanceSheetNewResult.setSemiInventoryAmount(dcBalanceSheetNew.getSemiInventoryAmount()
                .add(dcBalanceSheetNewModify.getSemiInventoryAmount()));

        //半成品在库金额=百伦
        dcBalanceSheetNewResult.setSemiBailunInventoryAmount(dcBalanceSheetNew.getSemiBailunInventoryAmount()
                .add(dcBalanceSheetNewModify.getSemiBailunInventoryAmount()));

        //半成品在库金额-哈尼曼
        dcBalanceSheetNewResult.setSemiHaniInventoryAmount(dcBalanceSheetNew.getSemiHaniInventoryAmount()
                .add(dcBalanceSheetNewModify.getSemiHaniInventoryAmount()));

        //半成品生产在库金额
        dcBalanceSheetNewResult.setSemiProdInventoryAmount(dcBalanceSheetNew.getSemiProdInventoryAmount()
                .add(dcBalanceSheetNewModify.getSemiProdInventoryAmount()));

        // 半成品在途金额 恢复,不汇总进去存货里面
        dcBalanceSheetNewResult.setSemiTransferAmount(dcBalanceSheetNew.getSemiTransferAmount()
                .add(dcBalanceSheetNewModify.getSemiTransferAmount()));

        //半成品在途金额=百伦
        dcBalanceSheetNewResult.setSemiBailunTransferAmount(dcBalanceSheetNew.getSemiBailunTransferAmount()
                .add(dcBalanceSheetNewModify.getSemiBailunTransferAmount()));

        //半成品在途金额=哈尼曼
        dcBalanceSheetNewResult.setSemiHaniTransferAmount(dcBalanceSheetNew.getSemiHaniTransferAmount()
                .add(dcBalanceSheetNewModify.getSemiHaniTransferAmount()));

        // 存货 金额  FBA在库金额+非FBA在库金额(不包含耗材仓)+FBA调拨在途金额(不包含调拨计划)+非FBA调拨在途金额(不包含调拨计划)+半成品在库金额+半成品生产在库金额+自产采购在途
        dcBalanceSheetNewResult.setInventoryAmount(dcBalanceSheetNew.getInventoryAmount()
                .add(dcBalanceSheetNewModify.getInventoryAmount()));

        dcBalanceSheetNewResult.setAccountsReceivable(dcBalanceSheetNew.getAccountsReceivable()
                .add(dcBalanceSheetNewModify.getAccountsReceivable()));

        dcBalanceSheetNewResultService.saveOrUpdate(dcBalanceSheetNewResult);
    }
}
