package com.bailuntec;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.core.SpringVersion;
import org.springframework.test.context.ActiveProfiles;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/1 3:28 下午
 */
@EnableFeignClients(basePackages = {"com.bailuntec.api", "com.bailuntec.*.api"})
@Slf4j
@SpringBootApplication(scanBasePackages = "com.bailuntec")
@ActiveProfiles("test")
public class TestApp {

    public static void main(String[] args) {
        String version = SpringVersion.getVersion();
        String version1 = SpringBootVersion.getVersion();
        log.info("SpringVersion  {}", version);
        log.info("SpringBootVersion  {}", version1);
        SpringApplication.run(TestApp.class, args);
    }

}
