package com.bailuntec.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.bailuntec.api.bailuntec.oa.OaApi;
import com.bailuntec.api.ebay.seller.EbayTransactionApi;
import com.bailuntec.api.ebay.seller.response.transaction.EbayTransactionRes;
import com.bailuntec.api.ebay.seller.response.transaction.Reference;
import com.bailuntec.api.ebay.seller.response.transaction.Transaction;
import com.bailuntec.application.IDcBaseCompanyAccountService;
import com.bailuntec.application.IEbayAccountReportTaskService;
import com.bailuntec.domain.DcBaseCompanyAccount;
import com.bailuntec.domain.DcBaseEbayTransaction;
import com.bailuntec.domain.EbayAccountReportTask;
import com.bailuntec.infrastructure.mapper.DcBaseEbayTransactionMapper;
import com.bailuntec.job.service.SyncEbayFeeService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-20
 * @Modified by:
 */
@Service
@Slf4j
public class SyncEbayFeeServiceImpl implements SyncEbayFeeService {
    @Resource
    private IEbayAccountReportTaskService ebayAccountReportTaskService;
    @Resource
    private IDcBaseCompanyAccountService dcBaseCompanyAccountService;
    @Resource
    private DcBaseEbayTransactionMapper dcBaseEbayTransactionMapper;

    //当前需要跑的账号
    private final static String[] RUN_ACCOUNT = new String[]{"ottlueilwitz3", "jalenhe", "uha4mmada", "rownmelody5",
            "nthonyp6ecket", "rayallen9", "barbara_spence95", "nbrysonhall", "credit4free", "barbara_spence95", "onesines",
            "coragios","suiedar","onesines","mmodatc","sjunqli","sytbing","entinaioc","senabchuan","talenmit","dudios",
            "elecajxin","foneneo","gulilaev","vackeo","bnetufay","pjonusta","Elesporm","shaelefy","behcvtg","Jiangblwin",
            "sytradenal","tmeiligda","gfruitan","Voasaon","Athltvc","nweifnmj","skillkedio","qmavitrd","covrivers",
            "fruicang","touitdare","sweypvep","mudrwman","vuhnoghe","chsh-b","chsh-c","belar-dnb"};

    @Resource
    private EbayTransactionApi ebayTransactionApi;

    @Resource
    private OaApi oaApi;

    @Override
    public void SyncEbayTransaction() {
        //获取未跑或失败的任务
        List<EbayAccountReportTask> ebayAccountReportTaskList = ebayAccountReportTaskService.list(
                new LambdaQueryWrapper<EbayAccountReportTask>()
                        .ne(EbayAccountReportTask::getStatus, 1)
        );
        /*List<EbayAccountReportTask> ebayAccountReportTaskList = ebayAccountReportTaskService.list(new LambdaQueryWrapper<EbayAccountReportTask>()
                .ge(EbayAccountReportTask::getStartTime, LocalDateTime.of(2021, 7, 7, 0, 0, 0))
                .lt(EbayAccountReportTask::getStartTime, LocalDateTime.of(2021, 7, 13, 0, 0, 0)));*/
        //获取账号信息
        List<Integer> accountIdList = ebayAccountReportTaskList.stream().map(x -> x.getAccountId()).distinct().collect(Collectors.toList());
        List<DcBaseCompanyAccount> accountList = dcBaseCompanyAccountService.list(
                new LambdaQueryWrapper<DcBaseCompanyAccount>()
                        .in(DcBaseCompanyAccount::getAccountId, accountIdList)
                        .in(DcBaseCompanyAccount::getAccountName, RUN_ACCOUNT)
        );
        //循环跑任务
        List<EbayAccountReportTask> needUpdateEbayAccountReportTaskList = new ArrayList<>();
        ebayAccountReportTaskList.forEach(x -> {
            if (accountList.stream().noneMatch(a -> a.getAccountId().equals(x.getAccountId()))) {
                return;
            }
            //获取token
            Integer pageNum = 1;
            StringBuffer accessToken = new StringBuffer("Bearer ");
            DcBaseCompanyAccount currentAccount = accountList.stream().filter(account -> account.getAccountId().equals(x.getAccountId())).findFirst().get();
            try {
                //禁用账号直接跳过
                if (!currentAccount.getStatus()) {
                    x.setStatus(2);
                    x.setErrorMsg("当前账号被禁用");
                    needUpdateEbayAccountReportTaskList.add(x);
                    return;
                }
                accessToken.append(JSON.parseObject(currentAccount.getAuthJson()).get("access_token"));
            } catch (Exception ex) {
                String msg = String.format("请求ebay广告服务异常,当前账号:%s，当前页码:%s", currentAccount.getAccountName(), pageNum);
                log.error(msg);
                x.setStatus(2);
                x.setErrorMsg(msg);
                needUpdateEbayAccountReportTaskList.add(x);
                return;
            }
            DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            String sTime = x.getStartTime().format(pattern);
            String eTime = x.getEndTime().format(pattern);
            String filter = String.format("transactionDate:[%s..%s]", sTime, eTime);//"transactionDate:[2021-05-18T00:00:01.000Z..2021-05-19T00:00:01.000Z]"
            List<Transaction> transactions = new ArrayList<>();
            boolean isSuccess = doGet(accessToken.toString(), filter, 1000, pageNum, transactions);
            if (isSuccess) {
                x.setStatus(1);
                save(transactions, currentAccount.getAccountId());
            } else {
                String msg = String.format("请求ebay广告服务异常,当前账号:%s，当前页码:%s", currentAccount.getAccountName(), pageNum);
                log.error(msg);
                x.setStatus(2);
                x.setErrorMsg(msg);
            }
            needUpdateEbayAccountReportTaskList.add(x);
        });
        ebayAccountReportTaskService.updateBatchById(needUpdateEbayAccountReportTaskList);
    }

    private boolean doGet(String accessToken, String filter, Integer limit, Integer pageNum, List<Transaction> transactions) {
        try {
            EbayTransactionRes ebayTransactionRes = ebayTransactionApi.getTransactions(accessToken, filter, limit, (pageNum - 1) * limit);
            if (ebayTransactionRes != null && !ebayTransactionRes.getTransactions().isEmpty()) {
                List<Transaction> feeTransactionList = ebayTransactionRes.getTransactions()
                        .stream()
                        .filter(item -> item.getTransactionId().startsWith("FEE")).collect(Collectors.toList());
                if (Optional.ofNullable(feeTransactionList).isPresent()) {
                    transactions.addAll(feeTransactionList);
                }
                pageNum++;
                return doGet(accessToken, filter, limit, pageNum, transactions);
            }
        } catch (Exception ex) {
            log.error(ex.toString());
            return false;
        }
        return true;
    }

    private void save(List<Transaction> transactions, Integer accountId) {
        if (transactions == null || transactions.isEmpty()) {
            return;
        }
        List<DcBaseEbayTransaction> dcBaseEbayTransactionList = JSON.parseArray(JSON.toJSONString(transactions), DcBaseEbayTransaction.class);
        dcBaseEbayTransactionList.forEach(x -> {
            Transaction transaction = transactions.stream().filter(item -> item.getTransactionId().equals(x.getTransactionId())).findFirst().get();
            if (transaction.getReferences() != null) {
                Reference reference = Optional.ofNullable(
                        transaction
                                .getReferences()
                                .stream()
                                .filter(item -> item.getReferenceType().equals("ITEM_ID"))
                                .findFirst()
                ).get().orElseGet(() -> null);
                x.setItemId(reference == null ? "" : reference.getReferenceId());
                x.setReferencesJson(JSON.toJSONString(transaction.getReferences()));
            }
            if (x.getTransactionDate() != null) {
                x.setTransactionDateBj(x.getTransactionDate().minusHours(15L));
                x.setTransactionDateShort(x.getTransactionDate().toLocalDate());
            }

            x.setValue(transaction.getAmount().getValue());
            x.setCurrency(transaction.getAmount().getCurrency());
            x.setUsername(transaction.getBuyer() == null ? "" : transaction.getBuyer().getUsername());
            x.setAccountId(accountId);
            try {
                x.setExchangeRate(oaApi.getExchangeRateByCurAndDate(x.getCurrency(), "CNY", x.getTransactionDateBj().toLocalDate()).getRate());
                x.setExchangeRateUsd(oaApi.getExchangeRateByCurAndDate(x.getCurrency(), "USD", x.getTransactionDateBj().toLocalDate()).getRate());
            } catch (Exception ex) {
                log.info(ex.toString());
            }
        });
        dcBaseEbayTransactionMapper.insertIgnoreExist(dcBaseEbayTransactionList);

    }
}
