package com.bailuntec.job.service;

import com.alibaba.fastjson.JSON;
import com.bailuntec.api.bailuntec.pams.PamsApi;
import com.bailuntec.api.bailuntec.pams.response.GetAccountTokenResp;
import com.bailuntec.api.bailuntec.pams.response.PamsResult;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.domain.DcBaseCompanyAccount;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class CompanyService {

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    PamsApi pamsApi;
    @Resource
    DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper;

    private static final String baseSyncCompany = "base-sync-company";

    @Transactional(rollbackFor = Exception.class)
    public void syncCompanyAccount() {

        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncCompany);

        PamsResult<List<GetAccountTokenResp>> result = pamsApi.getAccountToken();
        /*同步前禁用所有帐号*/
        dcBaseCompanyAccountMapper.updateSetStatusOff();

        result.getData().forEach(item -> {


            DcBaseCompanyAccount dcBaseCompanyAccount = new DcBaseCompanyAccount();
            BeanUtils.copyProperties(item, dcBaseCompanyAccount, "id");
            dcBaseCompanyAccount.setBjCreate(LocalDateTime.now());
            dcBaseCompanyAccount.setBjModified(LocalDateTime.now());

            int update = dcBaseCompanyAccountMapper.update(dcBaseCompanyAccount, new LambdaQueryWrapper<DcBaseCompanyAccount>()
                    .eq(DcBaseCompanyAccount::getAccountId, item.getAccountId())
                    .eq(DcBaseCompanyAccount::getCompanyId, item.getCompanyId()));
            if (update == 0) {
                dcBaseCompanyAccountMapper.insert(dcBaseCompanyAccount);
            }
            log.info("同步百伦帐号信息成功：{}", JSON.toJSONString(dcBaseCompanyAccount));
        });

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
