package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 半成品订单
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcSemiOrder对象", description="半成品订单")
public class DcSemiOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "采购系统单号")
    private String purchaseNo;

    @ApiModelProperty(value = "订单来源：0-手动添加或者系统跟内部导入，1-采购系统推送")
    private Integer source;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "交互时间")
    private LocalDateTime deliverDate;

    @ApiModelProperty(value = "销售员")
    private String saleUser;

    @ApiModelProperty(value = "采购员")
    private String purchaseUser;

    @ApiModelProperty(value = "订单类型|：1-调拨单，2-自发货单")
    private Integer type;

    @ApiModelProperty(value = "公司")
    private Integer companyId;

    @ApiModelProperty(value = "订单状态：0-待审批，1-已删除，2-待付款，3-驳回，4-")
    private Integer state;

    @ApiModelProperty(value = "发货状态：0-未发货，1-部分发货，2-完全发货")
    private Integer deliveryState;

    @ApiModelProperty(value = "订单总数")
    private Integer total;

    @ApiModelProperty(value = "初始交期")
    private LocalDateTime initDeliverDate;

    @ApiModelProperty(value = "订单类型：1-JIT订单，2-计划单")
    private Integer orderType;

    @ApiModelProperty(value = "交货需求")
    private String deliveryRemarks;

    @ApiModelProperty(value = "打包需求")
    @TableField("packRemarks")
    private String packRemarks;

    @ApiModelProperty(value = "付款类型：1-先款后货，2-先货后贷，3-无需付款，4-预付款")
    private Integer payType;

    @ApiModelProperty(value = "原始需求数量")
    private Integer originalQuantity;

    @ApiModelProperty(value = "总成本")
    private BigDecimal toalCostRecord;

    @ApiModelProperty(value = "总报价")
    private BigDecimal toalPriceRecord;

    @ApiModelProperty(value = "仓库")
    private Integer warehouseId;

    @ApiModelProperty(value = "最后更新时间")
    private LocalDateTime lastUpdateDate;

    @ApiModelProperty(value = " sku数量")
    private BigDecimal skuQuantity;

    @ApiModelProperty(value = "sku金额")
    private BigDecimal skuUnitCost;

    @ApiModelProperty(value = "sku单价")
    private BigDecimal skuUnitPrice;

    @ApiModelProperty(value = "sku")
    private String sku;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "订单唯一码")
    private Integer semiOrderId;


}
