package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 其他费用(其他应收款和其他应付款)
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcOtherCost对象", description="其他费用(其他应收款和其他应付款)")
public class DcOtherCost implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "统计日期")
    private LocalDate day;

    @ApiModelProperty(value = "1-其他应收，2-其他应付")
    private Integer type;

    @ApiModelProperty(value = "公司主体value")
    private Integer companyValue;

    @ApiModelProperty(value = "公司主体名称")
    private String companyName;

    @ApiModelProperty(value = "借款方/还款方")
    private String borrowerOrPayer;

    @ApiModelProperty(value = "期初金额")
    private BigDecimal startAmount;

    @ApiModelProperty(value = "借方发生额")
    private BigDecimal debitAmount;

    @ApiModelProperty(value = "贷方发生额")
    private BigDecimal creditAmount;

    @ApiModelProperty(value = "期末金额")
    private BigDecimal endAmount;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;


}
