package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBaseFinanceAmazonAdProduct对象", description = "亚马逊广告费用-平台SKU维度")
public class DcBaseFinanceAmazonAdProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @JsonProperty("campaignName")
    private String campaignName;

    @JsonProperty("campaignId")
    private String campaignId;

    @JsonProperty("adGroupName")
    private String adGroupName;

    @JsonProperty("adGroupId")
    private String adGroupId;

    @JsonProperty("impressions")
    private Integer impressions;

    @JsonProperty("clicks")
    private Integer clicks;

    @JsonProperty("cost")
    private BigDecimal cost;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("asin")
    private String asin;

    @JsonProperty("sku")
    private String sku;

    @JsonProperty("attributedConversions1d")
    private Integer attributedConversionsOneday;

    @JsonProperty("attributedConversions7d")
    private Integer attributedConversionsSevenday;

    @JsonProperty("attributedConversions14d")
    private Integer attributedConversionsFourteenday;

    @JsonProperty("attributedConversions30d")
    private Integer attributedConversionsThirtyday;

    @JsonProperty("attributedConversions1dSameSKU")
    private String attributedConversionsOnedaySameSku;

    @JsonProperty("attributedConversions7dSameSKU")
    private String attributedConversionsSevendaySameSku;

    @JsonProperty("attributedConversions14dSameSKU")
    private String attributedConversionsFourteendaySameSku;

    @JsonProperty("attributedConversions30dSameSKU")
    private String attributedConversionsThirtydaySameSku;

    @JsonProperty("attributedUnitsOrdered1d")
    private Integer attributedUnitsOrderedOneday;

    @JsonProperty("attributedUnitsOrdered7d")
    private Integer attributedUnitsOrderedSevenday;

    @JsonProperty("attributedUnitsOrdered14d")
    private String attributedUnitsOrderedFourteenday;

    @JsonProperty("attributedUnitsOrdered30d")
    private String attributedUnitsOrderedThirtyday;

    @JsonProperty("attributedSales1d")
    private Integer attributedSalesOneday;

    @JsonProperty("attributedSales7d")
    private Integer attributedSalesSevenday;

    @JsonProperty("attributedSales14d")
    private Integer attributedSalesFourteenday;

    @JsonProperty("attributedSales30d")
    private Integer attributedSalesThirtyday;

    @JsonProperty("attributedSales1dSameSKU")
    private String attributedSalesOnedaySameSku;

    @JsonProperty("attributedSales7dSameSKU")
    private String attributedSalesSevendaySameSku;

    @JsonProperty("attributedSales14dSameSKU")
    private String attributedSalesFourteendaySameSku;

    @JsonProperty("attributedSales30dSameSKU")
    private String attributedSalesThirtydaySameSku;

    @JsonProperty("attributedUnitsOrdered1dSameSKU")
    private String attributedUnitsOrderedOnedaySameSku;

    @JsonProperty("attributedUnitsOrdered7dSameSKU")
    private String attributedUnitsOrderedSevendaySameSku;

    @JsonProperty("attributedUnitsOrdered14dSameSKU")
    private String attributedUnitsOrderedFourteendaySameSku;

    @JsonProperty("attributedUnitsOrdered30dSameSKU")
    private String attributedUnitsOrderedThirtydaySameSku;

    @ApiModelProperty(value = "帐号ID")
    private Integer accountId;

    @ApiModelProperty(value = "公司ID")
    private Integer companyId;

    @ApiModelProperty(value = "本地创建时间")
    private LocalDateTime bjCreateTime;

    @ApiModelProperty(value = "本地更新时间")
    private LocalDateTime bjModifyTime;

    @ApiModelProperty(value = "报告日期")
    private LocalDate reportDate;

    @ApiModelProperty(value = "无意义字段")
    private String reportType;

    @ApiModelProperty(value = "转人民币汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty(value = "转美元汇率")
    private BigDecimal exchangeRateUsd;

    private Integer type;

}
