package com.bailuntec.application.impl;

import com.bailuntec.application.IDcBaseSkuMappingOnlineService;
import com.bailuntec.domain.DcBaseSkuMappingOnline;
import com.bailuntec.infrastructure.mapper.DcBaseSkuMappingOnlineMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.MyBatisExceptionTranslator;
import org.mybatis.spring.SqlSessionHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import java.util.Collection;
import java.util.Objects;

/**
 * <p>
 * 线上sku刊登资料 每小时刷新 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-22
 */
@Service
public class DcBaseSkuMappingOnlineServiceImpl extends ServiceImpl<DcBaseSkuMappingOnlineMapper, DcBaseSkuMappingOnline> implements IDcBaseSkuMappingOnlineService {


    @Override
    public void batchSync(Collection<DcBaseSkuMappingOnline> coll) {
        SqlSessionFactory sqlSessionFactory = SqlHelper.sqlSessionFactory(entityClass);
        SqlSessionHolder sqlSessionHolder = (SqlSessionHolder) TransactionSynchronizationManager.getResource(sqlSessionFactory);
        boolean transaction = TransactionSynchronizationManager.isSynchronizationActive();
        if (sqlSessionHolder != null) {
            SqlSession sqlSession = sqlSessionHolder.getSqlSession();
            //原生无法支持执行器切换，当存在批量操作时，会嵌套两个session的，优先commit上一个session
            //按道理来说，这里的值应该一直为false。
            sqlSession.commit(!transaction);
        }
        SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);
        if (!transaction) {
            log.warn("SqlSession [" + sqlSession + "] was not registered for synchronization because DataSource is not transactional");
        }
        try {
            coll.forEach(dcBaseSkuMappingOnline -> {
                DcBaseSkuMappingOnlineMapper mappingOnlineMapper = sqlSession.getMapper(DcBaseSkuMappingOnlineMapper.class);
                if (mappingOnlineMapper.update(dcBaseSkuMappingOnline, new LambdaQueryWrapper<DcBaseSkuMappingOnline>()
                        .eq(DcBaseSkuMappingOnline::getItemId, dcBaseSkuMappingOnline.getItemId())
                        .eq(DcBaseSkuMappingOnline::getSkuCode, dcBaseSkuMappingOnline.getSkuCode())
                        .eq(DcBaseSkuMappingOnline::getItemSku, dcBaseSkuMappingOnline.getItemSku())) == 0) {
                    mappingOnlineMapper.insert(dcBaseSkuMappingOnline);
                }
            });

            //非事务情况下，强制commit。
            sqlSession.commit(!transaction);
        } catch (Throwable t) {
            sqlSession.rollback();
            Throwable unwrapped = ExceptionUtil.unwrapThrowable(t);
            if (unwrapped instanceof RuntimeException) {
                MyBatisExceptionTranslator myBatisExceptionTranslator
                        = new MyBatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true);
                throw Objects.requireNonNull(myBatisExceptionTranslator.translateExceptionIfPossible((RuntimeException) unwrapped));
            }
            throw ExceptionUtils.mpe(unwrapped);
        } finally {
            sqlSession.close();
        }
    }
}
