package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcSemiDailyStock;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 半成品每天库存 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-11
 */
public interface DcSemiDailyStockMapper extends BaseMapper<DcSemiDailyStock> {

    @Select("select ifnull(sum(inventory_amount),0) from dc_semi_daily_stock where day = #{lastDay}")
    BigDecimal getSemiDailyStockSum(@Param("lastDay") LocalDate lastDay);

    @Select("select ifnull(sum(inventory_amount),0) from dc_semi_daily_stock where day = #{lastDay} and warehouse_id in (27,1,26,5,17,15,19,18,2)")
    BigDecimal getSemiBailunDailyStockSum(@Param("lastDay") LocalDate lastDay);

    @Select("select ifnull(sum(inventory_amount),0) from dc_semi_daily_stock where day = #{lastDay} and warehouse_id in (16,9)")
    BigDecimal getSemiHaNiDailyStockSum(@Param("lastDay") LocalDate lastDay);

    @Select("select ifnull(sum((jit_prod_stock + plan_prod_stock) * new_price),0) from dc_semi_stock_prod_daily where record_time = #{lastDay} and warehouse_name != '哈倪蔓美甲灌装车间'")
    BigDecimal getSemiProdInventoryAmountSum(@Param("lastDay") LocalDate lastDay);
}
