create definer = root@`%` view view_purchase_advise_supplier_price as
select `t1`.`suppliers_id`                                                    AS `suppliers_id`,
       `t1`.`warehouse_code`                                                  AS `warehouse_code`,
       `t1`.`main_id`                                                         AS `main_id`,
       sum((`t3`.`unit_price` * (case
                                     when (`t1`.`quantity_actual` > 0) then `t1`.`quantity_actual`
                                     else `t1`.`quantity_final_advise` end))) AS `price`
from (`bailun_datacenter`.`dc_auto_purchase_advise_detailed` `t1`
         left join `bailun_datacenter`.`dc_base_sku` `t3` on ((`t1`.`bailun_sku` = `t3`.`bailun_sku`)))
group by `t1`.`suppliers_id`, `t1`.`warehouse_code`, `t1`.`main_id`;

-- comment on column view_purchase_advise_supplier_price.suppliers_id not supported: 供应商id

-- comment on column view_purchase_advise_supplier_price.warehouse_code not supported: 仓库编码

-- comment on column view_purchase_advise_supplier_price.main_id not supported: 主表ID

