create definer = root@`%` view holiday_supplier_view as
select `bailun_datacenter`.`base_supplier_holiday_time`.`supplier_id`                       AS `supplier_id`,
       concat(convert(ifnull(`bailun_datacenter`.`base_supplier_holiday_time`.`start_date`, '') using utf8), ' - ',
              convert(ifnull(`bailun_datacenter`.`base_supplier_holiday_time`.`end_date`, '') using utf8), ' - ',
              ifnull(`bailun_datacenter`.`base_supplier_holiday_time`.`reason`, ''),
              ifnull(`bailun_datacenter`.`base_supplier_holiday_time`.`supplier_name`, '')) AS `title`
from `bailun_datacenter`.`base_supplier_holiday_time`
where ((`bailun_datacenter`.`base_supplier_holiday_time`.`status` = 1) and
       (now() >= date_format(`bailun_datacenter`.`base_supplier_holiday_time`.`start_date`, '%Y-%m-%d 00:00:00')) and
       (now() <= date_format(`bailun_datacenter`.`base_supplier_holiday_time`.`end_date`, '%Y-%m-%d 23:23:59')));

-- comment on column holiday_supplier_view.supplier_id not supported: 供应商id

